/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.commands.chunk.sub;

import java.util.UUID;
import net.achymake.chunks.commands.chunk.ChunkSubCommand;
import net.achymake.chunks.files.Message;
import net.achymake.chunks.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Members
extends ChunkSubCommand {
    @Override
    public String getName() {
        return "members";
    }

    @Override
    public String getDescription() {
        return "add or removes members to the chunk";
    }

    @Override
    public String getSyntax() {
        return "/chunk members add/remove target";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (player.hasPermission("chunks.command.chunk.members")) {
            Chunk chunk = player.getLocation().getChunk();
            if (args.length == 1) {
                if (PlayerConfig.get((OfflinePlayer)player).getStringList("members").isEmpty()) {
                    Message.sendMessage((CommandSender)player, "command.chunk.members.empty");
                } else {
                    Message.sendMessage((CommandSender)player, "command.chunk.members.title");
                    for (String uuidListed : PlayerConfig.get((OfflinePlayer)player).getStringList("members")) {
                        Message.sendMessage((CommandSender)player, "command.chunk.members.listed", player.getServer().getOfflinePlayer(UUID.fromString(uuidListed)).getName());
                    }
                }
            }
            if (args.length == 3) {
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
                if (args[1].equalsIgnoreCase("add")) {
                    if (PlayerConfig.get((OfflinePlayer)player).getStringList("members").contains(target.getUniqueId().toString())) {
                        Message.sendMessage((CommandSender)player, "command.chunk.members.add.error.member", target.getName());
                    } else {
                        members = PlayerConfig.get((OfflinePlayer)player).getStringList("members");
                        members.add(target.getUniqueId().toString());
                        PlayerConfig.setStringList((OfflinePlayer)player, "members", members);
                        Message.sendMessage((CommandSender)player, "command.chunk.members.add.success", target.getName());
                    }
                } else if (args[1].equalsIgnoreCase("remove")) {
                    if (PlayerConfig.get((OfflinePlayer)player).getStringList("members").contains(target.getUniqueId().toString())) {
                        members = PlayerConfig.get((OfflinePlayer)player).getStringList("members");
                        members.remove(target.getUniqueId().toString());
                        PlayerConfig.setStringList((OfflinePlayer)player, "members", members);
                        Message.sendMessage((CommandSender)player, "command.chunk.members.remove.success", target.getName());
                    } else {
                        Message.sendMessage((CommandSender)player, "command.chunk.members.remove.error-non-member", target.getName());
                    }
                }
            }
        }
    }
}

