/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.commands.chunk.sub;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.commands.chunk.ChunkSubCommand;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import net.achymake.chunks.files.PlayerConfig;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Claim
extends ChunkSubCommand {
    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public String getDescription() {
        return "claims the chunk";
    }

    @Override
    public String getSyntax() {
        return "/chunk claim";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (player.hasPermission("chunks.command.chunk.claim") && args.length == 1) {
            Chunk chunk = player.getLocation().getChunk();
            if (Chunks.getChunkConfig().isProtected(chunk)) {
                Message.sendMessage((CommandSender)player, "command.chunk.claim.error.protected");
            } else if (Chunks.getChunkConfig().isClaimed(chunk)) {
                if (Chunks.getChunkConfig().isOwner(player, chunk)) {
                    Message.sendMessage((CommandSender)player, "command.chunk.claim.error.owned", Chunks.getChunkConfig().getOwner(chunk).getName());
                } else {
                    Message.sendMessage((CommandSender)player, "command.chunk.claim.error.claimed", Chunks.getChunkConfig().getOwner(chunk).getName());
                }
            } else if (Config.get().getInt("max-claims") > PlayerConfig.get((OfflinePlayer)player).getInt("chunks.claimed")) {
                if (Chunks.getEconomy().getBalance((OfflinePlayer)player) >= Config.get().getDouble("claim.cost")) {
                    Chunks.getChunkConfig().claim(player, chunk);
                    Chunks.getChunkConfig().startClaimEffect(player);
                    Message.sendMessage((CommandSender)player, "command.chunk.claim.success", Chunks.getEconomy().format(Config.get().getDouble("claim.cost")));
                } else {
                    Message.sendMessage((CommandSender)player, "command.chunk.claim.error.insufficient-funds", Chunks.getEconomy().format(Config.get().getDouble("claim.cost")));
                }
            } else {
                Message.sendMessage((CommandSender)player, "command.chunk.claim.error.reached-limit", String.valueOf(PlayerConfig.get((OfflinePlayer)player).getInt("chunks.claimed")));
            }
        }
    }
}

