/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.commands.chunk;

import java.util.ArrayList;
import java.util.List;
import net.achymake.chunks.commands.chunk.ChunkSubCommand;
import net.achymake.chunks.commands.chunk.sub.Claim;
import net.achymake.chunks.commands.chunk.sub.Help;
import net.achymake.chunks.commands.chunk.sub.Members;
import net.achymake.chunks.commands.chunk.sub.TNT;
import net.achymake.chunks.commands.chunk.sub.Unclaim;
import net.achymake.chunks.files.Message;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ChunkCommand
implements CommandExecutor,
TabCompleter {
    private final ArrayList<ChunkSubCommand> chunkSubCommands = new ArrayList();

    public ChunkCommand() {
        this.chunkSubCommands.add(new Claim());
        this.chunkSubCommands.add(new Help());
        this.chunkSubCommands.add(new Members());
        this.chunkSubCommands.add(new TNT());
        this.chunkSubCommands.add(new Unclaim());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = (Player)sender;
        if (args.length == 0) {
            Message.sendMessage((CommandSender)player, "&cusage: &f/chunk help");
        } else {
            for (ChunkSubCommand commands : this.getSubCommands()) {
                if (!args[0].equals(commands.getName())) continue;
                commands.perform(player, args);
            }
        }
        return true;
    }

    public ArrayList<ChunkSubCommand> getSubCommands() {
        return this.chunkSubCommands;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("chunks.command.chunk.claim")) {
                commands.add("claim");
            }
            if (sender.hasPermission("chunks.command.chunk.help")) {
                commands.add("help");
            }
            if (sender.hasPermission("chunks.command.chunk.members")) {
                commands.add("members");
            }
            if (sender.hasPermission("chunks.command.chunk.tnt")) {
                commands.add("tnt");
            }
            if (sender.hasPermission("chunks.command.chunk.unclaim")) {
                commands.add("unclaim");
            }
        }
        if (args.length == 2 && sender.hasPermission("chunks.command.chunk.members") && args[0].equalsIgnoreCase("members")) {
            commands.add("add");
            commands.add("remove");
        }
        if (args.length == 3 && sender.hasPermission("chunks.command.chunk.members") && args[0].equalsIgnoreCase("members")) {
            for (OfflinePlayer players : sender.getServer().getOfflinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

