/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.api;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderProvider
extends PlaceholderExpansion {
    public String getIdentifier() {
        return "chunks";
    }

    public String getAuthor() {
        return "AchyMake";
    }

    public String getVersion() {
        return Chunks.getInstance().getDescription().getVersion();
    }

    public boolean canRegister() {
        return true;
    }

    public boolean register() {
        return super.register();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (params.equals("owner")) {
            if (Chunks.getChunkConfig().isClaimed(player.getLocation().getChunk())) {
                return Message.color("&f" + Chunks.getChunkConfig().getOwner(player.getLocation().getChunk()).getName() + "&r");
            }
            if (Chunks.getChunkConfig().isProtected(player.getLocation().getChunk())) {
                return Message.color("&fServer&r");
            }
            return Message.color("&fNone&r");
        }
        if (params.equals("access")) {
            if (Chunks.getChunkConfig().isClaimed(player.getLocation().getChunk())) {
                if (Chunks.getChunkConfig().hasAccess(player, player.getLocation().getChunk())) {
                    return Message.color("&aTrue&r");
                }
                return Message.color("&cFalse&r");
            }
            if (Chunks.getChunkConfig().isProtected(player.getLocation().getChunk())) {
                if (Chunks.getChunkConfig().hasAccess(player, player.getLocation().getChunk())) {
                    return Message.color("&aTrue&r");
                }
                return Message.color("&cFalse&r");
            }
            return Message.color("&aTrue&r");
        }
        if (params.equals("claimed")) {
            if (Chunks.getChunkConfig().isClaimed(player.getLocation().getChunk())) {
                return Message.color("&f" + Chunks.getChunkConfig().getOwner(player.getLocation().getChunk()).getName() + "&r");
            }
            return Message.color("&fNone&r");
        }
        if (params.equals("protected")) {
            if (Chunks.getChunkConfig().isProtected(player.getLocation().getChunk())) {
                return Message.color("&fServer&r");
            }
            return Message.color("&fNone&r");
        }
        return super.onPlaceholderRequest(player, params);
    }
}

