/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks;

import net.achymake.chunks.api.PlaceholderProvider;
import net.achymake.chunks.commands.Commands;
import net.achymake.chunks.files.ChunkConfig;
import net.achymake.chunks.files.Files;
import net.achymake.chunks.files.Message;
import net.achymake.chunks.listeners.Events;
import net.achymake.chunks.version.UpdateChecker;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Chunks
extends JavaPlugin {
    private static Economy econ = null;
    private static Chunks instance;
    private static ChunkConfig chunkConfig;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        instance = this;
        Files.start();
        if (!this.VaultInstalled()) {
            Message.sendLog("You have to install 'Vault'");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.setupEconomy()) {
            Message.sendLog("You have to install economy plugin");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupPlaceholders();
        chunkConfig = new ChunkConfig(this);
        Commands.start(this);
        Events.start(this);
        Message.sendLog("Enabled " + this.getName() + " " + this.getDescription().getVersion());
        new UpdateChecker(this, 108772).getUpdate();
    }

    public void onDisable() {
        if (Chunks.getChunkConfig() != null) {
            Chunks.getChunkConfig().getChunkEditors().clear();
        }
        Message.sendLog("Disabled " + this.getName() + " " + this.getDescription().getVersion());
    }

    private boolean VaultInstalled() {
        return this.getServer().getPluginManager().getPlugin("Vault") != null;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private void setupPlaceholders() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderProvider().register();
        } else {
            Message.sendLog("You have to install 'PlaceholderAPI'");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public static Economy getEconomy() {
        return econ;
    }

    public static ChunkConfig getChunkConfig() {
        return chunkConfig;
    }

    public static Chunks getInstance() {
        return instance;
    }
}

