/*
 * Copyright 2015 Alex Woodward
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.darkchocolatemurr.chocolatecrypt.main;

import java.util.ArrayList;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

import com.darkchocolatemurr.chocolatecrypt.api.CryptoAPI;
import com.darkchocolatemurr.chocolatecrypt.api.InitiatePresence;
import com.darkchocolatemurr.chocolatecrypt.api.Utility;

public class ChocolateCrypt extends JavaPlugin {
	
	/**Holds list of data*/
	public static ArrayList<String[]> data = new ArrayList<String[]>();
	
	/**Holds path of db file*/
	public static String dbPath = "";
	
	/**Holds intro string*/
	public static String introStr = ChatColor.DARK_GRAY + "[" +
			ChatColor.DARK_AQUA + "ChocolateCrypt" + ChatColor.DARK_GRAY +
			"]: ";
	
	
	public void onEnable() {
		Thread t1 = new Thread(new InitiatePresence());
		t1.start();
	}
	public void onDisable() {
		Utility.updateFile();
	}
	
	public boolean onCommand(CommandSender sender, Command cmd,
			String label, String args[]) {
		if(sender instanceof Player) {
			Player p = (Player)sender;
			boolean isMatch = false;
			String uuid = p.getUniqueId().toString();
			for(int i = 0; i < data.size() && !isMatch; i++) {
				if(uuid.equals(data.get(i)[0]))
					isMatch = true;
			}
			if(!isMatch) {
				String[] newData = new String[4];
				newData[0] = uuid;
				newData[1] = "1234";
				newData[2] = "1234";
				newData[3] = "hello world";
				data.add(newData);
			}
			
			if(label.equalsIgnoreCase("cc")) {
				if(args.length == 0) {
					return false;
				}
				if(Utility.containsChar(args[0], '\'')) {
					p.sendMessage(ChatColor.GOLD + "Error; your message cannot contain " +
							"single quotes");
					return true;
				}
				String message = "";
				for(String a : args)
					message += a + " ";
				message = message.substring(0, message.length()-1);
				String cypher = "";
				for(int i = 0; i < data.size(); i++) {
					if(data.get(i)[0].equals(uuid)) {
						cypher = data.get(i)[1];
						break;
					}
				}
				String encrypted = CryptoAPI.encrypt(message, cypher);
				for(int i = 0; i < data.size(); i++) {
					if(data.get(i)[0].equals(uuid)) {
						data.get(i)[3] = encrypted;
						break;
					}
				}
				Bukkit.broadcastMessage(introStr + 
						ChatColor.WHITE + p.getName() + ": " +
						ChatColor.DARK_PURPLE +
						encrypted);
				return true;
			}
			else if(label.equalsIgnoreCase("cca")) {
				if(p.isOp()) {
					if(args.length == 1) {
						if(Utility.containsChar(args[0], '\'')) {
							p.sendMessage(ChatColor.GOLD + "Error; player cannot contain " +
									"single quotes");
							return true;
						}
						CharSequence cs = args[0];
						Player target = null;
						for(Player players : 
							new ArrayList<Player>(Bukkit.getServer().getOnlinePlayers())) {
							if(players.getName().contains(cs)) {
								target = players;
								break;
							}
						}
						if(target == null) {
							p.sendMessage(ChatColor.GOLD + "Error; " + args[0] +
									" is not found - they must be online.");
							return false;
						}
						String toDecrypt = "";
						for(int i = 0; i < data.size(); i++) {
							if(data.get(i)[0].equals(target.getUniqueId().toString())) {
								toDecrypt = data.get(i)[3];
								break;
							}
						}
						if(toDecrypt.length() == 0) {
							p.sendMessage(ChatColor.GOLD + "Error; " + args[0] +
									" is found, but does not have any data to decrypt.");
							return true;
						}
						String cypher = "";
						for(int i = 0; i < data.size(); i++) {
							if(data.get(i)[0].equals(target.getUniqueId().toString())) {
								cypher = data.get(i)[1];
								break;
							}
						}
						if(cypher.length() == 0) {
							p.sendMessage(ChatColor.GOLD + "Error; your cypher data was not found.");
							return true;
						}
						String decrypted = CryptoAPI.decrypt(toDecrypt, cypher);
						p.sendMessage(introStr +
								ChatColor.GOLD +
								decrypted);
						return true;
					}
					else {
						return false;
					}
				}
				else {
					p.sendMessage(ChatColor.RED + "Error; you do not have permission " +
							"for this command.");
					return true;
				}
			}
			else if(label.equalsIgnoreCase("ccd")) {
				if(args.length == 1) {
					if(Utility.containsChar(args[0], '\'')) {
						p.sendMessage(ChatColor.GOLD + "Error; player cannot contain " +
								"single quotes");
						return true;
					}
					CharSequence cs = args[0];
					Player target = null;
					for(Player players : 
						new ArrayList<Player>(Bukkit.getServer().getOnlinePlayers())) {
						if(players.getName().contains(cs)) {
							target = players;
							break;
						}
					}
					if(target == null) {
						p.sendMessage(ChatColor.GOLD + "Error; " + args[0] +
								" is not found - they must be online.");
						return false;
					}
					String toDecrypt = "";
					for(int i = 0; i < data.size(); i++) {
						if(data.get(i)[0].equals(target.getUniqueId().toString())) {
							toDecrypt = data.get(i)[3];
							break;
						}
					}
					if(toDecrypt.length() == 0) {
						p.sendMessage(ChatColor.GOLD + "Error; " + args[0] +
								" is found, but does not have any data to decrypt.");
						return true;
					}
					String cypher = "";
					for(int i = 0; i < data.size(); i++) {
						if(data.get(i)[0].equals(p.getUniqueId().toString())) {
							cypher = data.get(i)[2];
							break;
						}
					}
					if(cypher.length() == 0) {
						p.sendMessage(ChatColor.GOLD + "Error; your cypher data was not found.");
						return true;
					}
					String decrypted = CryptoAPI.decrypt(toDecrypt, cypher);
					p.sendMessage(introStr +
							ChatColor.GOLD +
							decrypted);
					return true;
				}
				else
					return false;
			}
			else if(label.equalsIgnoreCase("chocolateencrypt")) {
				if(args.length == 1) {
					if(args[0].length() == 0) {
						return false;
					}
					if(Utility.containsChar(args[0], '\'')) {
						p.sendMessage(ChatColor.GOLD + "Error; your message cannot contain " +
								"single quotes");
						return true;
					}
					for(int i = 0; i < data.size(); i++) {
						if(data.get(i)[0].equals(uuid)) {
							data.get(i)[1] = args[0];
							p.sendMessage(introStr + ChatColor.GOLD +
									"The password that your /cc messages get " +
									"encrypted to has been updated.");
							return true;
						}
					}
				}
				else
					return false;
			}
			else if(label.equalsIgnoreCase("chocolatedecrypt")) {
				if(args.length == 1) {
					if(args[0].length() == 0) {
						return false;
					}
					if(Utility.containsChar(args[0], '\'')) {
						p.sendMessage(ChatColor.GOLD + "Error; your message cannot contain " +
								"single quotes");
						return true;
					}
					for(int i = 0; i < data.size(); i++) {
						if(data.get(i)[0].equals(uuid)) {
							data.get(i)[2] = args[0];
							p.sendMessage(introStr + ChatColor.GOLD +
									"The password that you decrypt messages to " +
									"has been updated.");
							return true;
						}
					}
				}
				else
					return false;
			}
			else if(label.equalsIgnoreCase("ChocolateHelp")) {
				p.sendMessage("Commands:");
				p.sendMessage("/cc <msg> to post an encrypted message");
				p.sendMessage("/ccd <pname> to decrypt someone\'s latest encrypted message");
				p.sendMessage("/cca <pname> to decrypt someone\'s latest encrypted message");
				p.sendMessage("/chocolateencrypt <pword> Set the password your messages are encrypted to");
				p.sendMessage("/chocolatedecrypt <pword> Set the password you decrypt messages as");
				p.sendMessage("/chocolatehelp to display commands");
				return true;
			}
		}
		return false;
	}
}
