/*
 * Copyright 2015 Alex Woodward
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.darkchocolatemurr.chocolatecrypt.api;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;


import com.darkchocolatemurr.chocolatecrypt.main.ChocolateCrypt;

public class Utility {
	
	
	/**updates the db file*/
	public static void updateFile() {
		File file = new File("ChocolateCrypt.db");
		try{
			if(!file.exists()) {
				file.createNewFile();
			}
		}catch(Exception e) { e.printStackTrace(); }
		ChocolateCrypt.dbPath = file.getAbsolutePath();
		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		try{
			Class.forName("org.sqlite.JDBC");
			con = DriverManager.getConnection("jdbc:sqlite:"+ChocolateCrypt.dbPath);
			DatabaseMetaData dmd = con.getMetaData();
			rs = dmd.getTables(null, null, "%", null);
			boolean existsTable = false;
			while(rs.next() && !existsTable) {
				if(rs.getString(3).equals("ChocolateData"))
					existsTable = true;
			}
			rs.close();
			if(!existsTable) {
				ps = con.prepareStatement("CREATE TABLE ChocolateData (" +
						"uuid string, chocolateencrypt string, chocolatedecrypt string, " +
						"lastmessage string);");
				ps.executeUpdate();
			}
			ps = con.prepareStatement("DELETE FROM ChocolateData;");
			ps.executeUpdate();
			for(int i = 0; i < ChocolateCrypt.data.size(); i++) {
				ps = con.prepareStatement("INSERT INTO ChocolateData " +
						"(uuid, chocolateencrypt, chocolatedecrypt, lastmessage) " +
						"VALUES(\'"+ChocolateCrypt.data.get(i)[0]+"\', \'"+
						ChocolateCrypt.data.get(i)[1]+"\', \'"+
						ChocolateCrypt.data.get(i)[2]+"\', \'"+
						ChocolateCrypt.data.get(i)[3]+"\');");
				ps.executeUpdate();
			}
		}catch(Exception e) { e.printStackTrace();
		}finally {
			try{
				if(con != null)
					con.close();
				if(ps != null)
					ps.close();
				if(rs != null)
					rs.close();
			}catch(Exception ee) { ee.printStackTrace(); }
		}
	}
	
	/**checks if a string contains a certain character*/
	public static boolean containsChar(String str, char ch) {
		for(int i = 0; i < str.length(); i++) {
			if(str.charAt(i) == ch)
				return true;
		}
		return false;
	}
}
