/*
 * Copyright 2015 Alex Woodward
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.darkchocolatemurr.chocolatecrypt.api;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import com.darkchocolatemurr.chocolatecrypt.main.ChocolateCrypt;

public class InitiatePresence implements Runnable {
	
	public void run() {
		File file = new File("ChocolateCrypt.db");
		try{
			if(!file.exists()) {
				file.createNewFile();
			}
		}catch(Exception e) { e.printStackTrace(); }
		ChocolateCrypt.dbPath = file.getAbsolutePath();
		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		try{
			Class.forName("org.sqlite.JDBC");
			con = DriverManager.getConnection("jdbc:sqlite:"+ChocolateCrypt.dbPath);
			DatabaseMetaData dmd = con.getMetaData();
			rs = dmd.getTables(null, null, "%", null);
			boolean existsTable = false;
			while(rs.next() && !existsTable) {
				if(rs.getString(3).equals("ChocolateData"))
					existsTable = true;
			}
			rs.close();
			if(!existsTable) {
				ps = con.prepareStatement("CREATE TABLE ChocolateData (" +
						"uuid string, chocolateencrypt string, chocolatedecrypt string, " +
						"lastmessage string);");
				ps.executeUpdate();
			}
			else {
				ps = con.prepareStatement("SELECT uuid, chocolateencrypt, " +
						"chocolatedecrypt, lastmessage FROM ChocolateData;");
				rs = ps.executeQuery();
				while(rs.next()) {
					String[] cData = new String[4];
					cData[0] = rs.getString("uuid");
					cData[1] = rs.getString("chocolateencrypt");
					cData[2] = rs.getString("chocolatedecrypt");
					cData[3] = rs.getString("lastmessage");
					ChocolateCrypt.data.add(cData);
				}
			}
		}catch(Exception e) { e.printStackTrace();
		}finally {
			try{
				if(con != null)
					con.close();
				if(ps != null)
					ps.close();
				if(rs != null)
					rs.close();
			}catch(Exception ee) { ee.printStackTrace(); }
		}
	}
}
