/*
 * Copyright 2015 Alex Woodward
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.darkchocolatemurr.chocolatecrypt.api;

import java.util.ArrayList;

public class CryptoAPI {
	
	/**Takes a message and a cypher, and encrypts it
	 * @param string message
	 * @param string encryption
	 * @return string encrypted message
	 */
	public static String encrypt(String message, String cypher) {
		ArrayList<Integer> m1 = new ArrayList<Integer>();
		ArrayList<Integer> c1 = new ArrayList<Integer>();
		for(char a : message.toCharArray())
			m1.add((int)a);
		for(char a : cypher.toCharArray())
			c1.add((int)a);
		ArrayList<Integer> e1 = new ArrayList<Integer>();
		for(int i = 0; i < m1.size(); i++) {
			int index = i % c1.size();
			e1.add(m1.get(i)^c1.get(index));
		}
		String encrypted = "";
		for(int a : e1)
			encrypted += String.valueOf((char)a);
		
		return encrypted;
	}
	
	/**Takes a message and a cypher, and decrypts it
	 * @param string message
	 * @param string encryption
	 * @return string decrypted message
	 */
	public static String decrypt(String message, String cypher) {
		ArrayList<Integer> m1 = new ArrayList<Integer>();
		ArrayList<Integer> c1 = new ArrayList<Integer>();
		for(char a : message.toCharArray())
			m1.add((int)a);
		for(char a : cypher.toCharArray())
			c1.add((int)a);
		ArrayList<Integer> e1 = new ArrayList<Integer>();
		for(int i = 0; i < m1.size(); i++) {
			int index = i % c1.size();
			e1.add(m1.get(i)^c1.get(index));
		}
		String decrypted = "";
		for(int a : e1)
			decrypted += String.valueOf((char)a);
		
		return decrypted;
	}
	
}
