/*
 * Decompiled with CFR 0.152.
 */
package de.niestrat.chatpings.main;

import de.niestrat.chatpings.UpdateChecker;
import de.niestrat.chatpings.commands.Help;
import de.niestrat.chatpings.commands.Info;
import de.niestrat.chatpings.commands.Prefix;
import de.niestrat.chatpings.commands.Reload;
import de.niestrat.chatpings.commands.ResetCooldown;
import de.niestrat.chatpings.commands.Toggle;
import de.niestrat.chatpings.config.Config;
import de.niestrat.chatpings.config.Language;
import de.niestrat.chatpings.config.MutePings;
import de.niestrat.chatpings.hooks.VAC;
import de.niestrat.chatpings.listeners.PingListener;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.parser.ParseException;

public class Main
extends JavaPlugin {
    private int version;
    public static Main Instance;

    public static String title(String title) {
        title = "&0[&bChat&cPings&0]&r " + title;
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public static Main getInstance() {
        return Instance;
    }

    public void onEnable() {
        Instance = this;
        this.getLogger().info(Main.title(ChatColor.GREEN + "ChatPings is now enabled!"));
        this.getServer().getPluginManager().registerEvents((Listener)new PingListener(), (Plugin)this);
        this.getCommand("pingreload").setExecutor((CommandExecutor)new Reload());
        this.getCommand("pinghelp").setExecutor((CommandExecutor)new Help());
        this.getCommand("pingtoggle").setExecutor((CommandExecutor)new Toggle());
        this.getCommand("pingprefix").setExecutor((CommandExecutor)new Prefix());
        this.getCommand("pinginfo").setExecutor((CommandExecutor)new Info());
        this.getCommand("pingresetcooldown").setExecutor((CommandExecutor)new ResetCooldown());
        if ("/".equals(Config.config.getString("ping.Prefix"))) {
            Config.config.set("ping.Prefix", (Object)"@");
            try {
                Config.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().warning("Illegal prefix found in config item 'ping.Prefix' - resetting to default.");
        }
        if ("boss".equals(Config.config.getString("pop-up.title")) && !VAC.checkVersion(190)) {
            Config.config.set("pop-up.title", (Object)"none");
            try {
                Config.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().warning("Server cannot use boss health for ping pop ups - must be atleast version 1.19! - resetting to default.");
        }
        try {
            Config.setDefaults();
            Language.setDefaults();
            new BukkitRunnable(){

                public void run() {
                    try {
                        MutePings.create();
                        MutePings.read();
                    }
                    catch (IOException | ParseException e) {
                        e.printStackTrace();
                    }
                }
            }.runTaskAsynchronously((Plugin)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    Object[] update = UpdateChecker.getUpdate();
                    if (update != null) {
                        Main.this.getServer().getConsoleSender().sendMessage(Main.title(ChatColor.AQUA + "" + ChatColor.BOLD + "A new version is available!") + "\n" + Main.title(ChatColor.AQUA + "" + ChatColor.BOLD + "Current version you're using: " + ChatColor.WHITE + Main.this.getDescription().getVersion()) + "\n" + Main.title(ChatColor.AQUA + "" + ChatColor.BOLD + "Latest version available: " + update[2]));
                        Main.this.getLogger().info(Main.title(ChatColor.AQUA + "Download link: https://www.spigotmc.org/resources/chatpings.76261/"));
                    } else {
                        Main.this.getLogger().info(Main.title(ChatColor.AQUA + "Plugin is up to date!"));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    public void onDisable() {
        try {
            MutePings.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

