/*
 * Decompiled with CFR 0.152.
 */
package de.niestrat.chatpings.config;

import de.niestrat.chatpings.main.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Language {
    public static File langFile = new File(Main.getInstance().getDataFolder(), "lang.yml");
    public static FileConfiguration lang = YamlConfiguration.loadConfiguration((File)langFile);

    public static void save() throws IOException {
        lang.save(langFile);
    }

    public static void setDefaults() throws IOException {
        lang.addDefault("title", (Object)"&0[&bChat&cPings&0]&r ");
        lang.addDefault("reload.start", (Object)"&bReloading configurations...");
        lang.addDefault("reload.done", (Object)"&bReload complete!");
        lang.addDefault("toggle.mute", (Object)"&bSuccessfully muted pings! &c[Only staff can ping you now!");
        lang.addDefault("toggle.unmute", (Object)"&bSuccessfully unmuted pings!");
        lang.addDefault("prefix.success", (Object)"&bSuccessfully set prefix to &e{prefix}&b!");
        lang.addDefault("prefix.reset", (Object)"&bSuccessfully reset prefix to default! (@)");
        lang.addDefault("help.reload", (Object)"&bReloads the config and language file.");
        lang.addDefault("help.prefix", (Object)"&bChanges the prefix used for pings.");
        lang.addDefault("help.toggle", (Object)"&bMakes that only staff can ping you.");
        lang.addDefault("help.help", (Object)"&bShows you this list of commands this plugin has.");
        lang.addDefault("help.resetcooldown", (Object)"&bResets a player's cooldown.");
        lang.addDefault("cooldown.resetsuccess", (Object)"&bSuccessfully reset cooldown for &e{player}&b!");
        lang.addDefault("error.permissions", (Object)"&cInsufficient permissions!");
        lang.addDefault("error.args", (Object)"&cToo few arguments!");
        lang.addDefault("error.prefix", (Object)"&cCannot set prefix to &e/ &cbecause it's a command prefix!");
        lang.addDefault("error.oncooldown", (Object)"&cYour ping is on a cooldown! Wait &e{time} &cmore second(s)!");
        lang.addDefault("error.player", (Object)"&cPlayer &e{player} &cdoes not exist!");
        lang.addDefault("error.notoncooldown", (Object)"&cPlayer &e{player} &cis not on cooldown!");
        lang.addDefault("pop-up.message", (Object)"&b&l{name} &6has pinged you!");
        lang.options().copyDefaults(true);
        Language.save();
    }

    public static void reloadLang() throws IOException {
        if (langFile == null) {
            langFile = new File(Main.getInstance().getDataFolder(), "lang.yml");
        }
        lang = YamlConfiguration.loadConfiguration((File)langFile);
        Language.setDefaults();
        Language.save();
    }

    public static String getString(String path) {
        String str = lang.getString(path);
        if (str == null) {
            return "";
        }
        str = str.replaceAll("''", "'");
        str = str.replaceAll("^'", "");
        str = str.replaceAll("'$", "");
        str = ChatColor.translateAlternateColorCodes((char)'&', (String)str);
        return str;
    }
}

