/*
 * Decompiled with CFR 0.152.
 */
package de.niestrat.chatpings.config;

import de.niestrat.chatpings.main.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static File configFile = new File(Main.getInstance().getDataFolder(), "config.yml");
    public static FileConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);

    public static void save() throws IOException {
        config.save(configFile);
    }

    public static void setDefaults() throws IOException {
        config.addDefault("ping.Prefix", (Object)"@");
        config.addDefault("ping.everyoneFormat", (Object)"everyone");
        config.addDefault("ping.someoneFormat", (Object)"someone");
        config.addDefault("ping.placeholder", (Object)"enter placeholder here");
        config.addDefault("pingcooldown.enabled", (Object)false);
        config.addDefault("pingcooldown.duration", (Object)5);
        config.addDefault("everyonePing.color", (Object)"&b&l");
        config.addDefault("everyonePing.sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
        config.addDefault("everyonePing.volume", (Object)"3.0F");
        config.addDefault("everyonePing.pitch", (Object)"0.5F");
        config.addDefault("playerPing.color", (Object)"&b&l");
        config.addDefault("playerPing.sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
        config.addDefault("playerPing.volume", (Object)"3.0F");
        config.addDefault("playerPing.pitch", (Object)"0.5F");
        config.addDefault("someonePing.color", (Object)"&b&l");
        config.addDefault("someonePing.sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
        config.addDefault("someonePing.volume", (Object)"3.0F");
        config.addDefault("someonePing.pitch", (Object)"0.5F");
        config.addDefault("someonePing.pingYourself", (Object)true);
        config.addDefault("someonePing.includePicked", (Object)true);
        config.addDefault("pop-up.title", (Object)"none");
        config.addDefault("pop-up.fade-in", (Object)1);
        config.addDefault("pop-up.duration", (Object)3);
        config.addDefault("pop-up.fade-out", (Object)1);
        config.addDefault("pop-up.bosscolor", (Object)"WHITE");
        config.options().copyDefaults(true);
        Config.save();
    }

    public static void reloadConfig() throws IOException {
        if (configFile == null) {
            configFile = new File(Main.getInstance().getDataFolder(), "config.yml");
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        Config.setDefaults();
        Config.save();
    }

    public static String getString(String path) {
        String str = config.getString(path);
        if (str == null) {
            return "";
        }
        str = str.replaceAll("''", "'");
        str = str.replaceAll("^'", "");
        str = str.replaceAll("'$", "");
        str = ChatColor.translateAlternateColorCodes((char)'&', (String)str);
        return str;
    }

    public static float getFloat(String path) {
        String str = Config.getString(path);
        return Float.parseFloat(str);
    }
}

