package at;

import java.io.File;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.IChatBaseComponent.ChatSerializer;
import net.minecraft.server.v1_12_R1.PacketPlayOutChat;


public class PrefixMain extends JavaPlugin implements Listener{
	
	FileConfiguration config;
	File cfile;
	
	public void onEnable(){
        config = getConfig();
        config.options().copyDefaults(true);
        saveConfig();
        cfile = new File(getDataFolder(), "config.yml");
		Bukkit.getConsoleSender().sendMessage("aChatMe > is enabled!");
		Bukkit.getPluginManager().registerEvents(this, this);
	}
	
	
	@EventHandler
	public void onChat(AsyncPlayerChatEvent e){
		Player p = e.getPlayer();
		
		String owner_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.owner"));
		String owner_raw2 = owner_raw.replace("%p", p.getName());
		String owner_prefix = owner_raw2.replace("%m", e.getMessage());
		
		String mod_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.moderator"));
		String mod_raw2 = mod_raw.replace("%p", p.getName());
		String mod_prefix = mod_raw2.replace("%m", e.getMessage());
		
		String sup_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.supporter"));
		String sup_raw2 = sup_raw.replace("%p", p.getName());
		String sup_prefix = sup_raw2.replace("%m", e.getMessage());
		
		String builder_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.builder"));
		String builder_raw2 = builder_raw.replace("%p", p.getName());
		String builder_prefix = builder_raw2.replace("%m", e.getMessage());
		
		String developer_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.developer"));
		String developer_raw2 = developer_raw.replace("%p", p.getName());
		String developer_prefix = developer_raw2.replace("%m", e.getMessage());
		
		String head_developer_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.headdeveloper"));
		String head_developer_raw2 = head_developer_raw.replace("%p", p.getName());
		String head_developer_prefix = head_developer_raw2.replace("%m", e.getMessage());
		
		String headadmin_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.headadmin"));
		String headadmin_raw2 = headadmin_raw.replace("%p", p.getName());
		String headadmin_prefix = headadmin_raw2.replace("%m", e.getMessage());
		
		String admin_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.admin"));
		String admin_raw2 = admin_raw.replace("%p", p.getName());
		String admin_prefix = admin_raw2.replace("%m", e.getMessage());
		
		String default_raw = ChatColor.translateAlternateColorCodes('&', config.getString("ChatMe.chat.default"));
		String default_raw2 = default_raw.replace("%p", p.getName());
		String default_prefix = default_raw2.replace("%m", e.getMessage());
		
		if(p.hasPermission("chatme.owner")){
			e.setFormat(owner_prefix);
		}else if(p.hasPermission("chatme.moderator")){
			e.setFormat(mod_prefix);
		}else if(p.hasPermission("chatme.supporter")){
			e.setFormat(sup_prefix);
		}else if(p.hasPermission("chatme.builder")){
			e.setFormat(builder_prefix);
		}else if(p.hasPermission("chatme.developer")){
			e.setFormat(developer_prefix);
		}else if(p.hasPermission("chatme.head_developer")){
			e.setFormat(head_developer_prefix);
		}else if(p.hasPermission("chatme.headadmin")){
			e.setFormat(headadmin_prefix);
		}else if(p.hasPermission("chatme.admin")){
			e.setFormat(admin_prefix);
		}else{
			e.setFormat(default_prefix);
		}
	}
	
	public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args){
		if(sender instanceof Player){
			Player p = (Player)sender;
		if(cmd.getName().equalsIgnoreCase("chatme")){
			if(p.hasPermission("chatme.cmd")){
				if(args.length == 0){
					
					IChatBaseComponent chat = ChatSerializer.a("{\"text\":\"6Visit my Page on SpigotMc.org to help\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://www.spigotmc.org/members/skipcrafter.152406/\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"Click to open Help-Page\",\"color\":\"red\"}]}}}");
					PacketPlayOutChat packet = new PacketPlayOutChat(chat);
					((CraftPlayer)p).getHandle().playerConnection.sendPacket(packet);
					
				}else if(args.length == 1){
					if(args[0].equalsIgnoreCase("reload")){
						config = YamlConfiguration.loadConfiguration(cfile);
						p.sendMessage("cChatMe areloaded!");
					}
				}
			}else{
				String noper = config.getString("ChatMe.noPermission");
				String noperm = ChatColor.translateAlternateColorCodes('&', noper);
				p.sendMessage(noperm);
			}
		}
		}else{
			sender.sendMessage("cYou must be a Player!");
		}
		return true;
	}
	
}
