/*
 * Decompiled with CFR 0.152.
 */
package challengerandomhotbar.manager;

import challengerandomhotbar.Main;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timer {
    private boolean running = false;
    private int time = Main.getInstance().getConfig().contains("timer.time") ? Main.getInstance().getConfig().getInt("timer.time") : 0;

    public Timer() {
        this.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String formatSeconds(int inputSeconds) {
        int seconds = inputSeconds % 60;
        int minutes = inputSeconds / 60 % 60;
        int hours = inputSeconds / 60 / 60;
        return hours + "h " + minutes + "m " + seconds + "s";
    }

    public void sendActionBar() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isRunning()) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.RED + "Timer ist pausiert"));
                continue;
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.GOLD.toString() + ChatColor.BOLD + this.formatSeconds(this.getTime())));
        }
    }

    public void save() {
        Main.getInstance().getConfig().set("timer.time", (Object)this.time);
    }

    private void run() {
        new BukkitRunnable(){

            public void run() {
                if (Timer.this.getTime() % 300 == 0 && Main.getGamemanager().isIngame()) {
                    Main.getGamemanager().newRandomHotbar();
                }
                Timer.this.sendActionBar();
                if (!Timer.this.isRunning()) {
                    return;
                }
                Timer.this.setTime(Timer.this.getTime() + 1);
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
    }
}

