/*
 * Decompiled with CFR 0.152.
 */
package challengerandomhotbar.manager;

import challengerandomhotbar.Main;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;

public class Gamemanager {
    public Gamestate gamestate = Gamestate.PREGAME;
    private static boolean isFreezed = true;

    public void setPregame() {
        this.gamestate = Gamestate.PREGAME;
        isFreezed = true;
    }

    public void setStarting() {
        this.gamestate = Gamestate.STARTING;
        Bukkit.getWorld((String)"world").setTime(0L);
        Bukkit.getOnlinePlayers().forEach(player -> {
            player.setGameMode(GameMode.SURVIVAL);
            player.setHealth(20.0);
            player.setFoodLevel(20);
            player.getInventory().clear();
            player.getInventory().setHelmet(null);
            player.getInventory().setChestplate(null);
            player.getInventory().setLeggings(null);
            player.getInventory().setBoots(null);
            player.setExp(0.0f);
            player.setLevel(0);
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
        });
        this.setIngame();
        Bukkit.broadcastMessage((String)(ChatColor.GOLD + "The challenge has started. Good luck"));
    }

    public void setIngame() {
        this.gamestate = Gamestate.INGAME;
        isFreezed = false;
        if (!Main.getTimer().isRunning()) {
            Main.getTimer().setRunning(true);
        }
    }

    public void setPaused() {
        this.gamestate = Gamestate.PAUSED;
        isFreezed = true;
        Main.getTimer().setRunning(false);
    }

    public void setPostgame() {
        this.gamestate = Gamestate.POSTGAME;
        Main.getTimer().setRunning(false);
        Bukkit.broadcastMessage((String)(ChatColor.GOLD.toString() + ChatColor.BOLD + "You finished the challenge in " + Main.getTimer().formatSeconds(Main.getTimer().getTime())));
    }

    public boolean isPregame() {
        return Objects.equals(this.gamestate.toString(), "PREGAME");
    }

    public boolean isIngame() {
        return Objects.equals(this.gamestate.toString(), "INGAME");
    }

    public boolean getIsFreezed() {
        return isFreezed;
    }

    public void setFreezed(boolean freezed) {
        isFreezed = freezed;
    }

    public void newRandomHotbar() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            player.getInventory().clear();
            player.getInventory().setHelmet(null);
            player.getInventory().setChestplate(null);
            player.getInventory().setLeggings(null);
            player.getInventory().setBoots(null);
            for (int i = 0; i <= 35; ++i) {
                if (i <= 8) {
                    player.getInventory().setItem(i, this.generateItem());
                    continue;
                }
                player.getInventory().setItem(i, this.generatePlaceholder());
            }
        });
    }

    private ItemStack generateItem() {
        Random random = new Random();
        List<Material> materials = Arrays.asList(Material.values());
        Material item = materials.get(random.nextInt(materials.size()));
        while (item.toString().contains("WALL_") || item.toString().contains("POTTED_") || item.toString().contains("CANDLE_CAKE") || item.toString().contains("_CAULDRON") || item.toString().contains("COMMAND") || item.toString().contains("VOID") || item.toString().contains("AIR") || item.toString().contains("_PLANT") || item.toString().contains("PISTON_") || item.toString().contains("PUMPKIN_STEM") || item.toString().contains("MELON_STEM") || item.toString().equals("DEBUG_STICK") || item.toString().equals("NETHER_PORTAL") || item.toString().equals("END_PORTAL") || item.toString().equals("END_GATEWAY") || item.toString().equals("BARRIER") || item.toString().equals("LAVA") || item.toString().equals("WATER") || item.toString().equals("FIRE") || item.toString().equals("SOUL_FIRE") || item.toString().equals("MOVING_PISTON") || item.toString().equals("POTATOES") || item.toString().equals("BUBBLE_COLUMN") || item.toString().equals("POWDER_SNOW") || item.toString().equals("TRIPWIRE") || item.toString().equals("CAVE_VINES") || item.toString().equals("CARROTS") || item.toString().equals("BEETROOTS") || item.toString().equals("BAMBOO_SAPLING") || item.toString().equals("SWEET_BERRY_BUSH") || item.toString().equals("TALL_SEAGRASS") || item.toString().equals("FROSTED_ICE") || item.toString().equals("REDSTONE_WIRE") || item.toString().equals("COCOA")) {
            item = materials.get(random.nextInt(materials.size()));
        }
        ItemStack stack = new ItemStack(item, this.getRandomInt(1, item.getMaxStackSize()));
        return stack;
    }

    private ItemStack generatePlaceholder() {
        ItemStack stack = new ItemStack(Material.BARRIER, 1);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(ChatColor.RED.toString() + ChatColor.BOLD + "slot blocked");
        stack.setItemMeta(meta);
        return stack;
    }

    public int getRandomInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static enum Gamestate {
        PREGAME,
        STARTING,
        INGAME,
        PAUSED,
        POSTGAME;

    }
}

