/*
 * Decompiled with CFR 0.152.
 */
package challengerandomhotbar.commands;

import challengerandomhotbar.Main;
import challengerandomhotbar.manager.Timer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandTimer
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "resume": {
                Timer timer = Main.getTimer();
                if (timer.isRunning()) {
                    sender.sendMessage(ChatColor.RED + "The timer is already running.");
                    break;
                }
                if (timer.getTime() == 0) {
                    Main.getGamemanager().setStarting();
                } else {
                    Main.getGamemanager().setIngame();
                    Bukkit.getOnlinePlayers().forEach(player -> player.setGameMode(GameMode.SURVIVAL));
                }
                timer.setRunning(true);
                Bukkit.getOnlinePlayers().forEach(player -> player.getInventory().remove(Material.NETHER_STAR));
                sender.sendMessage(ChatColor.GRAY + "The timer has been started.");
                break;
            }
            case "pause": {
                Timer timer = Main.getTimer();
                if (!timer.isRunning()) {
                    sender.sendMessage(ChatColor.RED + "The timer is not running.");
                    break;
                }
                Main.getGamemanager().setPaused();
                timer.setRunning(false);
                sender.sendMessage(ChatColor.GRAY + "The timer was stopped.");
                break;
            }
            case "time": {
                if (args.length != 2) {
                    sender.sendMessage(ChatColor.GRAY + "Usage" + ChatColor.DARK_GRAY + ": " + ChatColor.BLUE + "/timer time <time>");
                    return true;
                }
                try {
                    Timer timer = Main.getTimer();
                    timer.setRunning(false);
                    timer.setTime(Integer.parseInt(args[1]));
                    Main.getGamemanager().setPaused();
                    sender.sendMessage(ChatColor.GRAY + "The time was set to " + args[1] + ".");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.RED + "Your second parameter has to be a number.");
                }
                break;
            }
            case "reset": {
                Timer timer = Main.getTimer();
                timer.setRunning(false);
                timer.setTime(0);
                Main.getGamemanager().setPregame();
                sender.sendMessage(ChatColor.GRAY + "The timer was reset.");
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return false;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "Usage" + ChatColor.DARK_GRAY + ": " + ChatColor.BLUE + "/timer resume, /timer pause, /timer time <time>, /timer reset");
    }
}

