/*
 * Decompiled with CFR 0.152.
 */
package challengerandomhotbar;

import challengerandomhotbar.commands.CommandReset;
import challengerandomhotbar.commands.CommandTimer;
import challengerandomhotbar.manager.Freeze;
import challengerandomhotbar.manager.Gamemanager;
import challengerandomhotbar.manager.Listeners;
import challengerandomhotbar.manager.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private static Gamemanager gamemanager;
    private static Timer timer;

    public void onLoad() {
        instance = this;
        this.saveConfig();
        if (!this.getConfig().contains("timer.time")) {
            this.getConfig().set("timer.time", (Object)0);
        }
        if (!this.getConfig().contains("player_0")) {
            this.getConfig().set("player_0", (Object)0);
        }
        if (!this.getConfig().contains("player_1")) {
            this.getConfig().set("player_1", (Object)1);
        }
        if (!this.getConfig().contains("player_2")) {
            this.getConfig().set("player_2", (Object)2);
        }
        this.saveConfig();
        if (!this.getConfig().contains("isReset")) {
            this.getConfig().set("isReset", (Object)false);
            this.saveConfig();
            return;
        }
        if (this.getConfig().getBoolean("isReset")) {
            try {
                File world = new File(Bukkit.getWorldContainer(), "world");
                File nether = new File(Bukkit.getWorldContainer(), "world_nether");
                File end = new File(Bukkit.getWorldContainer(), "world_the_end");
                Files.walk(world.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                Files.walk(nether.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                Files.walk(end.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                world.mkdirs();
                nether.mkdirs();
                end.mkdirs();
                new File(world, "data").mkdirs();
                new File(world, "datapacks").mkdirs();
                new File(world, "playerdata").mkdirs();
                new File(world, "poi").mkdirs();
                new File(world, "region").mkdirs();
                new File(nether, "data").mkdirs();
                new File(nether, "datapacks").mkdirs();
                new File(nether, "playerdata").mkdirs();
                new File(nether, "poi").mkdirs();
                new File(nether, "region").mkdirs();
                new File(end, "data").mkdirs();
                new File(end, "datapacks").mkdirs();
                new File(end, "playerdata").mkdirs();
                new File(end, "poi").mkdirs();
                new File(end, "region").mkdirs();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getConfig().set("isReset", (Object)false);
            this.saveConfig();
        }
    }

    public void onEnable() {
        gamemanager = new Gamemanager();
        timer = new Timer();
        PluginManager manager = Bukkit.getPluginManager();
        manager.registerEvents((Listener)new Listeners(), (Plugin)this);
        manager.registerEvents((Listener)new Freeze(), (Plugin)this);
        this.getCommand("reset").setExecutor((CommandExecutor)new CommandReset());
        this.getCommand("timer").setExecutor((CommandExecutor)new CommandTimer());
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("isReset")) {
            this.getConfig().set("timer.time", (Object)0);
        } else {
            timer.save();
        }
        this.saveConfig();
    }

    public static Main getInstance() {
        return instance;
    }

    public static Gamemanager getGamemanager() {
        return gamemanager;
    }

    public static Timer getTimer() {
        return timer;
    }
}

