/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chairs.listeners.interact;

import net.achymake.chairs.Chairs;
import net.achymake.chairs.settings.ChairSettings;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class ClickSlabs
implements Listener {
    public ClickSlabs(Chairs plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClickEvent(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!event.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!event.getPlayer().hasPermission("chairs.sit")) {
            return;
        }
        if (!event.getPlayer().isOnGround()) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            return;
        }
        if (!Tag.SLABS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        if (!((Slab)event.getClickedBlock().getBlockData()).getType().equals((Object)Slab.Type.BOTTOM)) {
            return;
        }
        if (!event.getBlockFace().equals((Object)BlockFace.UP)) {
            return;
        }
        ChairSettings.saveLocation(event.getPlayer());
        Location location = event.getClickedBlock().getLocation().add(0.5, 0.0, 0.5);
        location.setY((double)event.getClickedBlock().getY() - 0.4);
        location.setYaw(event.getPlayer().getLocation().getYaw() + 180.0f);
        location.setPitch(0.0f);
        ArmorStand armorStand = (ArmorStand)event.getClickedBlock().getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        ChairSettings.addPassenger((Entity)armorStand, event.getPlayer());
    }
}

