/*
 * Decompiled with CFR 0.152.
 */
package net.kerimbalci.bungeeplayermove;

import java.util.HashMap;
import java.util.Locale;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public enum BungeePlayerMoveMessage {
    NO_PERMISSION,
    COMMAND_CORRECT_USAGE,
    COMMAND_PLAYER_NOT_ONLINE,
    MOVE_NO_PLAYER_FOUND,
    MOVE_NO_SERVER,
    MOVE_SUCCESSFULLY,
    MOVE_ALREADY_ON_THIS_SERVER,
    MOVE_FAILED,
    MOVE_PLAYER,
    SERVER_DOES_NOT_EXIST;

    private String Default = new String();
    private HashMap<String, String> languages = new HashMap();

    public String getMessage(Object sender) {
        if (sender instanceof ProxiedPlayer) {
            String text;
            String language;
            ProxiedPlayer player = (ProxiedPlayer)sender;
            String result = this.getDefault();
            if (player.getLocale() != null && (language = player.getLocale().getLanguage()) != null && (text = this.getLanguage(language)) != null) {
                result = text;
            }
            return result;
        }
        return this.getDefault();
    }

    public String getDefault() {
        return this.Default;
    }

    public void setDefault(String aDefault) {
        this.Default = aDefault;
    }

    public String getLanguage(String language) {
        if (this.languages.containsKey(language)) {
            return this.languages.get(language);
        }
        return this.Default;
    }

    public void addLanguage(String locale, String text) {
        this.languages.put(locale, text);
    }

    public HashMap<String, String> getLanguages() {
        return this.languages;
    }

    public void setGerman(String text) {
        this.addLanguage(Locale.GERMAN.getLanguage(), text);
    }

    public String getGerman() {
        return this.languages.get(Locale.GERMAN.getLanguage());
    }

    static {
        NO_PERMISSION.setDefault(ChatColor.RED + "You do not have the pluginName to do that!");
        NO_PERMISSION.setGerman(ChatColor.RED + "Du hast nicht die Befugnisse, das zu tun!");
        COMMAND_CORRECT_USAGE.setDefault(ChatColor.RED + "Incorrect usage! Correct usage: " + ChatColor.AQUA);
        COMMAND_CORRECT_USAGE.setGerman(ChatColor.RED + "Falsche Benutzung! Richtige Benutzung: " + ChatColor.AQUA);
        COMMAND_PLAYER_NOT_ONLINE.setDefault(ChatColor.RED + "Player " + "{player}" + ChatColor.RED + " is currently not online!");
        COMMAND_PLAYER_NOT_ONLINE.setGerman(ChatColor.RED + "Der Spieler " + "{player}" + ChatColor.RED + " ist zurzeit nicht Online!");
        MOVE_NO_PLAYER_FOUND.setDefault(ChatColor.RED + "There is no online player found to move!");
        MOVE_NO_PLAYER_FOUND.setGerman(ChatColor.RED + "Es konnte kein online Spieler zum bewegen gefunden werden!");
        MOVE_NO_SERVER.setDefault(ChatColor.RED + "You need to define a server to move player " + "{player}" + ChatColor.RED + " to your defined server");
        MOVE_NO_SERVER.setGerman(ChatColor.RED + "Du musst noch einen Server definieren, um den Spieler " + "{player}" + ChatColor.RED + " zu einem Server zu bewegen!");
        MOVE_SUCCESSFULLY.setDefault(ChatColor.GREEN + "You moved " + "{player}" + ChatColor.GREEN + " from {fromServer} server to {toServer} server!");
        MOVE_SUCCESSFULLY.setGerman(ChatColor.GREEN + "Du hast " + "{player}" + ChatColor.GREEN + " vom {fromServer} Server zum {toServer} Server bewegt!");
        MOVE_ALREADY_ON_THIS_SERVER.setDefault(ChatColor.RED + "Player " + "{player}" + ChatColor.RED + " is already connected to {server}!");
        MOVE_ALREADY_ON_THIS_SERVER.setGerman(ChatColor.RED + "Der Spieler " + "{player}" + ChatColor.RED + " ist bereits auf dem Server {server}!");
        MOVE_FAILED.setDefault(ChatColor.RED + "Failed to moved " + "{player}" + ChatColor.RED + " from {fromServer} server to {toServer} server!");
        MOVE_FAILED.setGerman(ChatColor.RED + "Der Spieler " + "{player}" + ChatColor.RED + " konnte vom {fromServer} Server zum {toServer} Server nicht bewegt werden!");
        MOVE_PLAYER.setDefault(ChatColor.GREEN + "You were moved from {fromServer} server to {toServer} server from {issuer}!");
        MOVE_PLAYER.setGerman(ChatColor.GREEN + "Du wurdest von {issuer} vom {fromServer} Server zum {toServer} Server bewegt!");
        SERVER_DOES_NOT_EXIST.setDefault(ChatColor.RED + "Server {server} does not exists!");
        SERVER_DOES_NOT_EXIST.setGerman(ChatColor.RED + "Der Server {server} existiert nicht!");
    }
}

