/*
 * Decompiled with CFR 0.152.
 */
package net.kerimbalci.bungeeplayermove;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.kerimbalci.bungeeplayermove.BungeePlayerMoveCommand;
import net.kerimbalci.bungeeplayermove.BungeePlayerMoveMessage;
import net.kerimbalci.bungeeplayermove.BungeePlayerMovePlugin;
import net.kerimbalci.bungeeplayermove.PacketSendPlayerMove;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeePlayerMoveListener
implements Listener {
    @EventHandler
    public void ServerConnectEvent(final ServerConnectEvent event) {
        PacketSendPlayerMove packet;
        ProxiedPlayer player = event.getPlayer();
        ServerInfo server = event.getTarget();
        PacketSendPlayerMove tempPacket = null;
        for (PacketSendPlayerMove sendPlayerMove : BungeePlayerMoveCommand.MOVE_PLAYER) {
            if (!sendPlayerMove.getPlayer().equalsIgnoreCase(player.getName()) || !sendPlayerMove.getToServer().equals(server)) continue;
            tempPacket = sendPlayerMove;
            break;
        }
        if ((packet = tempPacket) != null) {
            if (event.isCancelled()) {
                BungeePlayerMoveCommand.MOVE_PLAYER.remove(packet);
                packet.setType("event_cancelled");
                CommandSender commandSender = BungeePlayerMovePlugin.PLUGIN.getCommandSender(packet.getIssuer());
                if (commandSender != null) {
                    BungeePlayerMoveCommand.moveInfo(commandSender, packet);
                }
            } else {
                BungeeCord.getInstance().getScheduler().schedule((Plugin)BungeePlayerMovePlugin.PLUGIN, new Runnable(){

                    @Override
                    public void run() {
                        if (BungeePlayerMoveCommand.MOVE_PLAYER.contains(packet)) {
                            packet.setType("timeout");
                            BungeePlayerMoveCommand.sendInformation(packet);
                            event.setCancelled(true);
                        }
                    }
                }, 3L, TimeUnit.SECONDS);
            }
        }
    }

    @EventHandler
    public void ServerConnectedEvent(ServerConnectedEvent event) {
        ProxiedPlayer player = event.getPlayer();
        Server server = event.getServer();
        PacketSendPlayerMove packet = null;
        for (PacketSendPlayerMove sendPlayerMove : BungeePlayerMoveCommand.MOVE_PLAYER) {
            if (!sendPlayerMove.getPlayer().equalsIgnoreCase(player.getName()) || !sendPlayerMove.getToServer().equals(server.getInfo())) continue;
            packet = sendPlayerMove;
            break;
        }
        if (packet != null) {
            if (!packet.getIssuer().equals(player.getName())) {
                player.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_PLAYER.getMessage(player).replace("{fromServer}", packet.getFromServer().getName()).replace("{toServer}", server.getInfo().getName()).replace("{issuer}", packet.getIssuer())));
                if (packet.getReason() != null && !packet.getReason().isEmpty()) {
                    player.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.GRAY + (player.getLocale().equals(Locale.GERMAN) ? "Grund: " : "Reason: ") + ChatColor.LIGHT_PURPLE + packet.getReason())));
                }
            }
            BungeePlayerMoveCommand.MOVE_PLAYER.remove(packet);
            packet.setType("successfully");
            BungeePlayerMoveCommand.sendInformation(packet);
        }
    }
}

