/*
 * Decompiled with CFR 0.152.
 */
package net.kerimbalci.bungeeplayermove;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kerimbalci.bungeeplayermove.BungeePlayerMoveMessage;
import net.kerimbalci.bungeeplayermove.BungeePlayerMovePlugin;
import net.kerimbalci.bungeeplayermove.PacketSendPlayerMove;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlayerMoveCommand
extends Command {
    public static List<PacketSendPlayerMove> MOVE_PLAYER = new ArrayList<PacketSendPlayerMove>();

    public BungeePlayerMoveCommand(String command) {
        super(command);
    }

    public void execute(CommandSender sender, String[] args) {
        ServerInfo toServerInfo;
        String[] split;
        if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".command")) {
            sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
            return;
        }
        if (args.length <= 0) {
            sender.sendMessage(TextComponent.fromLegacyText((String)(BungeePlayerMoveMessage.COMMAND_CORRECT_USAGE.getMessage(sender) + "/" + this.getName() + " " + "[player]" + " " + "<server>" + " " + "(reason)")));
            return;
        }
        if (args.length <= 1) {
            sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_NO_SERVER.getMessage(sender).replace("{player}", args[0])));
            return;
        }
        String permission = null;
        String fromServer = null;
        String toServer = args[1];
        String player = null;
        if (args[0].toLowerCase().startsWith("server:")) {
            fromServer = args[0].substring("server:".length());
            split = fromServer.split(",permission:");
            if (split.length > 1) {
                permission = split[1];
                fromServer = split[0];
            }
        } else if (args[0].toLowerCase().startsWith("permission:") && (split = (permission = args[0].substring("permission:".length())).split(",server:")).length > 1) {
            permission = split[0];
            fromServer = split[1];
        }
        if (permission == null && fromServer == null) {
            player = args[0];
        }
        String reason = "";
        if (args.length >= 3) {
            for (int i = 2; i < args.length; ++i) {
                reason = reason + (reason.isEmpty() ? "" : " ") + args[i];
            }
        }
        if ((toServerInfo = BungeeCord.getInstance().getServerInfo(toServer)) == null) {
            sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.SERVER_DOES_NOT_EXIST.getMessage(sender).replace("{server}", toServer)));
            return;
        }
        if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".to_server.*") && !sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".to_server." + toServer)) {
            sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
            return;
        }
        if (player != null) {
            ProxiedPlayer movePlayer = BungeeCord.getInstance().getPlayer(player);
            if (movePlayer == null) {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.COMMAND_PLAYER_NOT_ONLINE.getMessage(sender).replace("{player}", player)));
                return;
            }
            if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server.*") && !sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server." + movePlayer.getServer().getInfo().getName())) {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
                return;
            }
            PacketSendPlayerMove packet = new PacketSendPlayerMove(sender.getName(), player, toServerInfo, reason);
            BungeePlayerMoveCommand.movePlayer(movePlayer, packet);
        } else {
            ArrayList<ProxiedPlayer> movePlayers = new ArrayList<ProxiedPlayer>();
            if (fromServer != null) {
                ServerInfo serverInfo = BungeeCord.getInstance().getServerInfo(fromServer);
                if (serverInfo == null) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.SERVER_DOES_NOT_EXIST.getMessage(sender).replace("{server}", fromServer)));
                    return;
                }
                if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".command.server")) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
                    return;
                }
                if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server.*") && !sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server." + fromServer)) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
                    return;
                }
                movePlayers.addAll(serverInfo.getPlayers());
            }
            if (permission != null) {
                if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".command.permission")) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.NO_PERMISSION.getMessage(sender)));
                    return;
                }
                if (fromServer != null) {
                    for (ProxiedPlayer proxiedPlayer : BungeeCord.getInstance().getServerInfo(fromServer).getPlayers()) {
                        if (!movePlayers.contains(proxiedPlayer) || proxiedPlayer.hasPermission(permission)) continue;
                        movePlayers.remove(proxiedPlayer);
                    }
                } else {
                    for (ProxiedPlayer proxiedPlayer : BungeeCord.getInstance().getPlayers()) {
                        if (!sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server.*") && !sender.hasPermission(BungeePlayerMoveCommand.pluginName() + ".from_server." + proxiedPlayer.getName()) || !proxiedPlayer.hasPermission(permission)) continue;
                        movePlayers.add(proxiedPlayer);
                    }
                }
            }
            if (movePlayers.isEmpty()) {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_NO_PLAYER_FOUND.getMessage(sender)));
                return;
            }
            for (ProxiedPlayer proxiedPlayer : movePlayers) {
                PacketSendPlayerMove packet = new PacketSendPlayerMove(sender.getName(), proxiedPlayer.getName(), toServerInfo, reason);
                BungeePlayerMoveCommand.movePlayer(proxiedPlayer, packet);
            }
        }
    }

    public static void movePlayer(ProxiedPlayer player, final PacketSendPlayerMove packet) {
        ServerInfo fromServer = player.getServer().getInfo();
        packet.setFromServer(fromServer);
        if (!fromServer.equals(packet.getToServer())) {
            if (packet.getToServer() == null) {
                packet.setType("server_not_found");
                BungeePlayerMoveCommand.sendInformation(packet);
                return;
            }
            MOVE_PLAYER.add(packet);
            player.connect(packet.getToServer());
        } else {
            packet.setType("player_already_on_this_server");
            BungeePlayerMoveCommand.sendInformation(packet);
        }
        BungeeCord.getInstance().getScheduler().schedule((Plugin)BungeePlayerMovePlugin.PLUGIN, new Runnable(){

            @Override
            public void run() {
                if (MOVE_PLAYER.contains(packet)) {
                    packet.setType("timeout");
                    BungeePlayerMoveCommand.sendInformation(packet);
                }
            }
        }, 5L, TimeUnit.SECONDS);
    }

    public static void sendInformation(PacketSendPlayerMove packet) {
        CommandSender commandSender = BungeePlayerMovePlugin.PLUGIN.getCommandSender(packet.getIssuer());
        if (commandSender != null) {
            BungeePlayerMoveCommand.moveInfo(commandSender, packet);
        }
    }

    public static void moveInfo(CommandSender sender, PacketSendPlayerMove packet) {
        switch (packet.getType()) {
            case "server_not_found": {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.SERVER_DOES_NOT_EXIST.getMessage(sender).replace("{server}", packet.getToServer().getName())));
                return;
            }
            case "player_already_on_this_server": {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_ALREADY_ON_THIS_SERVER.getMessage(sender).replace("{server}", packet.getToServer().getName()).replace("{player}", packet.getPlayer())));
                return;
            }
            case "successfully": {
                sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_SUCCESSFULLY.getMessage(sender).replace("{fromServer}", packet.getFromServer().getName()).replace("{toServer}", packet.getToServer().getName()).replace("{player}", packet.getPlayer())));
                return;
            }
        }
        sender.sendMessage(TextComponent.fromLegacyText((String)BungeePlayerMoveMessage.MOVE_FAILED.getMessage(sender).replace("{fromServer}", packet.getFromServer().getName()).replace("{toServer}", packet.getToServer().getName()).replace("{player}", packet.getPlayer())));
    }

    public static String pluginName() {
        return "bungeeplayermove";
    }
}

