/*
 * Decompiled with CFR 0.152.
 */
package fr.rhaz.bungeeloginredirect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public class Bungee
extends Plugin
implements Listener {
    private ArrayList<ProxiedPlayer> loggedin;
    private ArrayList<ProxiedPlayer> connecting;
    private HashMap<ProxiedPlayer, ServerInfo> reconnect;
    private Configuration config;
    private List<String> cmds;
    private String msg;
    private Title title;
    private static Bungee plugin;

    public void onEnable() {
        plugin = this;
        this.loggedin = new ArrayList();
        this.reconnect = new HashMap();
        this.connecting = new ArrayList();
        this.title = this.getProxy().createTitle();
        this.title.title(Bungee.text("\u00a78"));
        this.title.subTitle(Bungee.text("\u00a78Connecting..."));
        this.title.fadeIn(0).stay(10).fadeOut(0);
        this.getProxy().registerChannel("BLR");
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, new Command("blr"){

            public void execute(CommandSender sender, String[] args) {
                if (sender.hasPermission(String.valueOf(this.getName()) + ".reload")) {
                    if (args.length >= 1 && args[0].equalsIgnoreCase("reload")) {
                        Bungee.this.reload();
                        sender.sendMessage((BaseComponent)new TextComponent("Config reloaded."));
                    } else {
                        sender.sendMessage((BaseComponent)new TextComponent("/" + this.getName() + " <reload>"));
                    }
                } else {
                    sender.sendMessage((BaseComponent)new TextComponent("\u00a7cYou don't have permission."));
                }
            }
        });
        this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (ProxiedPlayer player : Bungee.this.connecting) {
                    Bungee.this.title.send(player);
                }
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        this.reload();
    }

    public static Bungee instance() {
        return plugin;
    }

    private void reload() {
        this.config = this.loadConfig("config.yml");
        this.cmds = this.config.getStringList("allowed-commands");
        this.msg = this.config.getString("message");
    }

    private Configuration loadConfig(String name) {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), name)).exists()) {
            try {
                Files.copy(this.getResourceAsStream(name), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Configuration config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendMessage(String[] strings, ServerInfo server) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            try {
                out.writeUTF(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        server.sendData("BLR", stream.toByteArray());
    }

    @EventHandler(priority=64)
    public void onLogin(ServerConnectEvent e) {
        if (!this.loggedin.contains(e.getPlayer())) {
            ServerInfo server;
            ListenerInfo listener = e.getPlayer().getPendingConnection().getListener();
            String servername = (String)listener.getServerPriority().get(0);
            ServerInfo target = e.getTarget();
            this.reconnect.put(e.getPlayer(), target);
            if (this.getProxy().getServers().containsKey(servername) && !target.equals(server = this.getProxy().getServerInfo(servername))) {
                if (e.getPlayer().getServer() == null) {
                    e.setTarget(server);
                } else {
                    e.getPlayer().sendMessage(Bungee.text(this.msg));
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=64)
    public void onDisconnect(PlayerDisconnectEvent e) {
        this.loggedin.remove(e.getPlayer());
    }

    @EventHandler(priority=-64)
    public void onChat(ChatEvent e) {
        if (e.getSender() instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)e.getSender();
            String cmd = e.getMessage().split(" ")[0].toLowerCase();
            if (!this.cmds.contains(cmd) && !this.loggedin.contains(player)) {
                e.setCancelled(true);
                if (!this.msg.isEmpty()) {
                    player.sendMessage(Bungee.text(this.msg));
                }
            }
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getTag().equals("BLR") && e.getSender() instanceof Server) {
            ByteArrayInputStream stream = new ByteArrayInputStream(e.getData());
            DataInputStream in = new DataInputStream(stream);
            try {
                String subtag = in.readUTF();
                if (subtag.equals("redirect")) {
                    String name = in.readUTF();
                    ProxiedPlayer player = this.getProxy().getPlayer(name);
                    this.loggedin.add(player);
                    ServerInfo server = player.getServer().getInfo();
                    if (this.reconnect.containsKey(player) && !this.reconnect.get(player).equals(server)) {
                        this.reconnect(player, this.reconnect.get(player));
                    }
                    this.reconnect.remove(player);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void reconnect(final ProxiedPlayer player, ServerInfo server) {
        this.title.send(player);
        this.connecting.add(player);
        player.connect(server, (Callback)new Callback<Boolean>(){

            public void done(Boolean arg0, Throwable arg1) {
                Bungee.this.connecting.remove(player);
            }
        });
    }

    public static BaseComponent[] text(String string) {
        return TextComponent.fromLegacyText((String)string.replaceAll("&", "\u00a7"));
    }
}

