/*
 * Decompiled with CFR 0.152.
 */
package me.victorgamer15.brandblocker;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class BrandBlocker
extends JavaPlugin
implements PluginMessageListener,
Listener {
    String prefix;
    HashMap<String, String> player_brands = new HashMap();

    public void onEnable() {
        String[] div = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        String version = div[1];
        this.getLogger().info("Server running version 1." + version);
        if (Integer.parseInt(version) < 13) {
            Messenger messenger = Bukkit.getMessenger();
            messenger.registerIncomingPluginChannel((Plugin)this, "MC|Brand", (PluginMessageListener)this);
            this.getLogger().info("Registered 1.12- listener");
        } else {
            Messenger messenger = Bukkit.getMessenger();
            messenger.registerIncomingPluginChannel((Plugin)this, "minecraft:brand", (PluginMessageListener)this);
            this.getLogger().info("Registered 1.13+ listener");
        }
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("prefix"));
        this.saveDefaultConfig();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.player_brands.remove(e.getPlayer().getName());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("brandblocker")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a74\u00a7m--------------------------");
                sender.sendMessage("\u00a7c\u00a7lBrandBlocker \u00a77v" + this.getDescription().getVersion());
                sender.sendMessage("\u00a77by VictorGamer15");
                sender.sendMessage("\u00a77");
                sender.sendMessage("\u00a7cUsage \u00a74\u00bb");
                sender.sendMessage("\u00a7c\u00a7l\u25cf check \u00a77(player)");
                sender.sendMessage("\u00a7c\u00a7l\u25cf reload");
                sender.sendMessage("\u00a74\u00a7m--------------------------");
            } else if (args[0].equalsIgnoreCase("check")) {
                if (sender.hasPermission("brandblocker.usage")) {
                    if (args.length <= 1) {
                        sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("specify-player-name")));
                    } else if (this.player_brands.containsKey(args[1])) {
                        sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("check-succesful")).replace("%player%", args[1]).replace("%brand%", this.player_brands.get(args[1])));
                    } else {
                        sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("check-failed")).replace("%player%", args[1]));
                    }
                } else {
                    sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("no-permission")));
                }
            } else if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("brandblocker.usage")) {
                    this.reloadConfig();
                    sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("config-reload")));
                } else {
                    sender.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("no-permission")));
                }
            }
            return false;
        }
        return false;
    }

    public void onPluginMessageReceived(String channel, Player p, byte[] msg) {
        String brand = new String(msg, StandardCharsets.UTF_8).substring(1);
        this.player_brands.put(p.getName(), brand);
        if (!this.getConfig().getBoolean("enable")) {
            return;
        }
        if (this.getConfig().getBoolean("geyser-support") && p.getName().contains(Objects.requireNonNull(this.getConfig().getString("geyser-prefix")))) {
            return;
        }
        if (this.getConfig().getString("mode", "blacklist").equals("blacklist")) {
            for (String str : this.getConfig().getStringList("blocked-brands")) {
                if (!brand.toLowerCase().contains(str.toLowerCase())) continue;
                if (p.hasPermission("brandblocker.bypass")) {
                    return;
                }
                String kickMsg = this.getConfig().getString("kick-message");
                assert (kickMsg != null);
                p.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)kickMsg));
                this.getLogger().info(this.getConfig().getString("console-log").replace("%player%", p.getName()).replace("%brand%", brand));
                return;
            }
        } else if (this.getConfig().getString("mode", "whitelist").equals("whitelist")) {
            for (String str : this.getConfig().getStringList("blocked-brands")) {
                if (!brand.toLowerCase().contains(str.toLowerCase())) continue;
                return;
            }
            if (p.hasPermission("brandblocker.bypass")) {
                return;
            }
            String kickMsg = this.getConfig().getString("kick-message");
            assert (kickMsg != null);
            p.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)kickMsg));
            this.getLogger().info(this.getConfig().getString("console-log").replace("%player%", p.getName()).replace("%brand%", brand));
            return;
        }
    }

    public void onDisable() {
        this.player_brands.clear();
    }
}

