/*
 * Decompiled with CFR 0.152.
 */
package fr.axetomy.blockfinder.manager;

import fr.axetomy.blockfinder.Main;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Messages {
    private Main pl;
    private FileConfiguration config;

    public Messages(Main main) {
        this.pl = main;
        this.config = this.pl.getConfig();
    }

    public void cmdBlockFinderHelp(CommandSender sender) {
        for (int i = 0; i < this.config.getList("Messages.commands.help").size(); ++i) {
            sender.sendMessage(this.config.getList("Messages.commands.help").get(i).toString().replace("&", "\u00a7"));
        }
    }

    public void cmdBlockFinderPlayer(CommandSender sender) {
        sender.sendMessage(this.pl.prefix + this.config.getString("Messages.commands.wrong-player").replace("&", "\u00a7"));
    }

    public void cmdBlockFinderBlock(CommandSender sender) {
        sender.sendMessage(this.pl.prefix + this.config.getString("Messages.commands.wrong-block").replace("&", "\u00a7"));
    }

    public void cmdBlockFinderChunkRange(CommandSender sender) {
        sender.sendMessage(this.pl.prefix + this.config.getString("Messages.commands.wrong-level").replace("&", "\u00a7"));
    }

    public void cmdNoPermission(CommandSender sender) {
        sender.sendMessage(this.pl.prefix + this.config.getString("Messages.commands.no-permission").replace("&", "\u00a7"));
    }

    public void blockFinderReceived(Player player, String material, String level) {
        player.sendMessage(this.pl.prefix + this.config.getString("Messages.blockfinder.received").replace("&", "\u00a7").replace("%material%", material).replace("%level%", level));
    }

    public void blockFinderGiven(CommandSender sender, String material, String level, String playerName) {
        sender.sendMessage(this.pl.prefix + this.config.getString("Messages.blockfinder.given").replace("&", "\u00a7").replace("%material%", material).replace("%level%", level).replace("%player%", playerName));
    }

    public void blockFinderYes(Player player, String material, String level) {
        this.pl.actionBar().sendActionBar(player, this.config.getString("Messages.blockfinder.block-found").replace("&", "\u00a7").replace("%material%", material).replace("%radius%", 2 * Integer.parseInt(level) - 1 + "x" + (2 * Integer.parseInt(level) - 1)));
    }

    public void blockFinderNo(Player player, String material, String level) {
        this.pl.actionBar().sendActionBar(player, this.config.getString("Messages.blockfinder.nothing-found").replace("&", "\u00a7").replace("%material%", material).replace("%radius%", 2 * Integer.parseInt(level) - 1 + "x" + (2 * Integer.parseInt(level) - 1)));
    }
}

