/*
 * Decompiled with CFR 0.152.
 */
package fr.axetomy.blockfinder.commands;

import fr.axetomy.blockfinder.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CmdBlockFinder
implements TabCompleter,
CommandExecutor {
    private Main pl;
    private FileConfiguration config;

    public CmdBlockFinder(Main main) {
        this.pl = main;
        this.config = this.pl.getConfig();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String msg, String[] args) {
        block16: {
            if (sender.hasPermission("blockfinder.admin") || sender.hasPermission("blockfinder.give")) {
                if (args.length <= 0) {
                    this.pl.messages().cmdBlockFinderHelp(sender);
                } else if (args.length == 4) {
                    if (args[0].equalsIgnoreCase("give")) {
                        if (Bukkit.getPlayer((String)args[1]) != null && Bukkit.getPlayer((String)args[1]).isOnline()) {
                            if (Material.getMaterial((String)args[2]) != null && Material.valueOf((String)args[2]).isBlock() && !this.config.getString("Blockfinder.blacklist").contains(args[2])) {
                                try {
                                    Integer integer = Integer.parseInt(args[3]);
                                    if (integer <= 2) {
                                        Player p = Bukkit.getPlayer((String)args[1]);
                                        this.pl.items().blockFinderGive(p, args[2], args[3]);
                                        this.pl.messages().blockFinderReceived(p, args[2], args[3]);
                                        this.pl.messages().blockFinderGiven(sender, args[2], args[3], p.getName());
                                        break block16;
                                    }
                                    this.pl.messages().cmdBlockFinderChunkRange(sender);
                                }
                                catch (NumberFormatException e) {
                                    this.pl.messages().cmdBlockFinderChunkRange(sender);
                                }
                            } else {
                                this.pl.messages().cmdBlockFinderBlock(sender);
                            }
                        } else {
                            this.pl.messages().cmdBlockFinderPlayer(sender);
                        }
                    } else {
                        this.pl.messages().cmdBlockFinderHelp(sender);
                    }
                } else if (args.length > 5) {
                    this.pl.messages().cmdBlockFinderHelp(sender);
                    return false;
                }
            } else {
                this.pl.messages().cmdNoPermission(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String msg, String[] args) {
        if (sender.hasPermission("blockfinder.admin") || sender.hasPermission("blockfinder.give")) {
            if (args.length <= 0) {
                return Collections.emptyList();
            }
            if (args.length == 1) {
                return Arrays.asList("give");
            }
            if (args.length == 2) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player all : Bukkit.getOnlinePlayers()) {
                    list.add(all.getName());
                }
                return list;
            }
            if (args.length == 3) {
                ArrayList<String> list = new ArrayList<String>();
                for (Material material : Material.values()) {
                    if (!material.isBlock()) continue;
                    list.add(material.toString());
                }
                return list;
            }
            if (args.length == 4) {
                return Arrays.asList("1", "2");
            }
        }
        return Collections.emptyList();
    }
}

