/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Tools
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public Tools(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("tools")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tools")).setDescription(plugin.getMessage("toolsCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("tools")).setUsage(plugin.getMessage("toolsCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("tool")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("tool")).setDescription(plugin.getMessage("toolCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("tool")).setUsage(plugin.getMessage("toolCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("workbench")).setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            block7 : switch (label) {
                case "tools": {
                    TextComponent workbench = new TextComponent("\u00a72\u00a7lWorkbench");
                    workbench.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getMessage("toolsCommandClickThisToPutWorkbench")).create()));
                    workbench.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tool workbench"));
                    sender.sendMessage(this.plugin.getMessage("toolsCommandAListOfAvailableTools"));
                    sender.sendMessage(" ");
                    player.spigot().sendMessage((BaseComponent)workbench);
                    break;
                }
                case "tool": {
                    if (args.length == 0) {
                        sender.sendMessage(this.plugin.getMessage("toolCommandWrongUsage"));
                        return true;
                    }
                    String arg = args[0];
                    switch (arg) {
                        case "workbench": 
                        case "craft": 
                        case "craftingtable": {
                            player.openWorkbench(null, true);
                            break block7;
                        }
                    }
                    this.plugin.getMessage("toolCommandCannotFindOption").replace("{0}", args[0]);
                    break;
                }
                case "workbench": 
                case "craft": 
                case "craftingtable": {
                    player.openWorkbench(null, true);
                }
            }
        } else {
            sender.sendMessage(this.plugin.getMessage("notAPlayer"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1 && label.equals("tool")) {
            ArrayList toollist = Lists.newArrayList();
            toollist.add("workbench");
            return toollist;
        }
        if (args.length >= 1) {
            return Collections.emptyList();
        }
        return null;
    }
}

