/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Speed
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public Speed(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("flyspeed")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("flyspeed")).setDescription(plugin.getMessage("flyspeedCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("flyspeed")).setUsage(plugin.getMessage("flyspeedCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("walkspeed")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("walkspeed")).setDescription(plugin.getMessage("walkspeedCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("walkspeed")).setUsage(plugin.getMessage("walkspeedCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("notAPlayer"));
            return true;
        }
        Player player = (Player)sender;
        switch (label) {
            case "flyspeed": {
                if (args.length == 0) {
                    sender.sendMessage(this.plugin.getMessage("flyspeedCommandWrongUsage"));
                    return true;
                }
                if (args.length != 1) break;
                if (args[0].equals("reset")) {
                    sender.sendMessage(this.plugin.getMessage("flyspeedCommandReset"));
                    player.setFlySpeed(0.1f);
                    return true;
                }
                try {
                    int test = Integer.parseInt(args[0]);
                    if (test < 1 || test > 10) {
                        sender.sendMessage(this.plugin.getMessage("flyspeedCommandReturnError"));
                        return true;
                    }
                    float speed = (float)test / 10.0f;
                    player.setFlySpeed(speed);
                    sender.sendMessage(this.plugin.getMessage("flyspeedSuccessMessage").replace("{0}", "" + speed));
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.plugin.getMessage("speedCommandsNumberError"));
                }
                return true;
            }
            case "walkspeed": {
                if (args.length == 0) {
                    sender.sendMessage(this.plugin.getMessage("walkspeedCommandWrongUsage"));
                    return true;
                }
                if (args.length != 1) break;
                if (args[0].equals("reset")) {
                    sender.sendMessage(this.plugin.getMessage("walkspeedCommandReset"));
                    player.setWalkSpeed(0.2f);
                    return true;
                }
                try {
                    int test = Integer.parseInt(args[0]);
                    if (test < 1 || test > 10) {
                        sender.sendMessage(this.plugin.getMessage("walkspeedCommandReturnError"));
                        return true;
                    }
                    float speed = (float)test / 10.0f;
                    player.setWalkSpeed(speed);
                    sender.sendMessage(this.plugin.getMessage("walkspeedSuccessMessage").replace("{0}", "" + speed));
                    break;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.plugin.getMessage("speedCommandsNumberError"));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 1) {
                ArrayList list = Lists.newArrayList();
                list.add("9");
                list.add("8");
                list.add("7");
                list.add("6");
                list.add("5");
                list.add("4");
                list.add("3");
                list.add("2");
                list.add("1");
                list.add("reset");
                return list;
            }
            if (args.length >= 2) {
                return Collections.emptyList();
            }
        }
        return null;
    }
}

