/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Spawn
implements CommandExecutor {
    final Main plugin;
    final FileConfiguration spawnConfig = new YamlConfiguration();

    public Spawn(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("spawn")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("spawn")).setDescription(plugin.getMessage("spawnCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("spawn")).setUsage(plugin.getMessage("spawnCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("setspawn")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("setspawn")).setDescription(plugin.getMessage("setSpawnCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("setspawn")).setUsage(plugin.getMessage("setSpawnCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("notAPlayer"));
            return true;
        }
        Player player = (Player)sender;
        File spawnConfigFile = new File(this.plugin.getDataFolder(), "spawn.yml");
        this.createSpawnFile();
        switch (label) {
            case "spawn": {
                if (!this.spawnConfig.getBoolean("spawn.IsEnabled")) {
                    sender.sendMessage(this.plugin.getMessage("spawnCommandNoSpawnpoint"));
                    return true;
                }
                World world = Bukkit.getWorld((String)Objects.requireNonNull(this.spawnConfig.getString("spawn.World")));
                double x = this.spawnConfig.getDouble("spawn.X");
                double y = this.spawnConfig.getDouble("spawn.Y");
                double z = this.spawnConfig.getDouble("spawn.Z");
                float yaw = (float)this.spawnConfig.getDouble("spawn.Yaw");
                float pitch = (float)this.spawnConfig.getDouble("spawn.Pitch");
                if (this.plugin.getConfig().getBoolean("SpawnCommandWaitThing")) {
                    player.sendMessage("\u00a7e\u00a7lTeleportation commencing...");
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.sendMessage("\u00a7e\u00a7lYou will be teleported in 3 seconds"), 20L);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.sendMessage("\u00a7e\u00a7lYou will be teleported in 2 seconds"), 40L);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.sendMessage("\u00a7e\u00a7lYou will be teleported in 1 second"), 60L);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.teleport(new Location(world, x, y, z, yaw, pitch)), 70L);
                break;
            }
            case "setspawn": {
                this.spawnConfig.set("spawn.IsEnabled", (Object)true);
                String world = player.getLocation().getWorld().getName();
                double x = player.getLocation().getX();
                double y = player.getLocation().getY();
                double z = player.getLocation().getZ();
                double yaw = player.getLocation().getYaw();
                double pitch = player.getLocation().getPitch();
                this.spawnConfig.set("spawn.World", (Object)world);
                this.spawnConfig.set("spawn.X", (Object)x);
                this.spawnConfig.set("spawn.Y", (Object)y);
                this.spawnConfig.set("spawn.Z", (Object)z);
                this.spawnConfig.set("spawn.Yaw", (Object)yaw);
                this.spawnConfig.set("spawn.Pitch", (Object)pitch);
                sender.sendMessage(this.plugin.getMessage("spawnCommandSpawnSet"));
                try {
                    this.spawnConfig.save(spawnConfigFile);
                    break;
                }
                catch (IOException e) {
                    sender.sendMessage(this.plugin.getMessage("spawnCommandErrorSaving"));
                }
            }
        }
        return true;
    }

    public void ifItExists() {
        File spawnConfigFile = new File(this.plugin.getDataFolder(), "homes.yml");
        if (!spawnConfigFile.exists()) {
            this.plugin.saveResource("homes.yml", true);
        }
    }

    private void createSpawnFile() {
        File spawnConfigFile = new File(this.plugin.getDataFolder(), "spawn.yml");
        this.ifItExists();
        try {
            this.spawnConfig.load(spawnConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.spawnConfig.save(spawnConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

