/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class Rules
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public Rules(Main plugin) {
        this.plugin = plugin;
        Path rulesfile = plugin.getDataFolder().toPath().resolve("rules.txt");
        if (Files.notExists(rulesfile, new LinkOption[0])) {
            Bukkit.getConsoleSender().sendMessage("\u00a74\u00a7lCould not find your rules.txt file, creating one for you!");
            plugin.saveResource("rules.txt", false);
        }
        Objects.requireNonNull(this.plugin.getCommand("rules")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("rules")).setDescription(plugin.getMessage("rulesCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("rules")).setUsage(plugin.getMessage("rulesCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Scanner sc;
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        Path rulesfile = this.plugin.getDataFolder().toPath().resolve("rules.txt");
        if (Files.notExists(rulesfile, new LinkOption[0])) {
            sender.sendMessage(this.plugin.getMessage("rulesCommandCouldNotFindRules"));
            this.plugin.saveResource("rules.txt", false);
        }
        sender.sendMessage(this.plugin.getMessage("rulesCommandPresentRules"));
        sender.sendMessage("");
        try {
            sc = new Scanner(rulesfile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (sc.hasNextLine()) {
            sender.sendMessage(sc.nextLine().replace('&', '\u00a7'));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Collections.emptyList();
        }
        return null;
    }
}

