/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class Mutechat
implements CommandExecutor,
Listener,
TabCompleter {
    final Main plugin;
    public boolean chatmuted;

    public Mutechat(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("mutechat")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("mutechat")).setDescription(plugin.getMessage("mutechatCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("mutechat")).setUsage(plugin.getMessage("mutechatCommandUsage"));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        boolean bl = this.chatmuted = !this.chatmuted;
        if (sender instanceof ConsoleCommandSender) {
            if (this.chatmuted) {
                sender.sendMessage(this.plugin.getMessage("mutechatCommandInstanceOfConsoleMutedChat"));
            } else {
                sender.sendMessage(this.plugin.getMessage("mutechatCommandInstanceOfConsoleUnmutedChat"));
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.chatmuted) {
                if (p.hasPermission("permissions.chatmuted.bypass")) {
                    p.sendMessage(this.plugin.getMessage("mutechatCommandChatMutedHasPermission").replace("{0}", sender.getName()));
                    continue;
                }
                p.sendMessage(this.plugin.getMessage("mutechatCommandChatMuted").replace("{0}", sender.getName()));
                continue;
            }
            p.sendMessage(this.plugin.getMessage("mutechatCommandChatUnmuted").replace("{0}", sender.getName()));
        }
        return true;
    }

    @EventHandler
    @Deprecated
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.chatmuted && !player.hasPermission("permission.mutechat.bypass")) {
            player.sendMessage("\u00a74\u00a7lYou cannot speak now, chat is currently muted.");
            event.setCancelled(true);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 1) {
            return Collections.emptyList();
        }
        return null;
    }
}

