/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;

public class Motd
implements CommandExecutor,
Listener,
TabCompleter {
    final Main plugin;

    public Motd(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("motd")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("motd")).setDescription(plugin.getMessage("motdCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("motd")).setUsage(plugin.getMessage("motdCommandUsage"));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        this.sendPlayerMotdToPlayer(sender);
        return true;
    }

    public void sendPlayerMotdToPlayer(CommandSender p) {
        int size = this.plugin.getConfig().getStringList("JoinGame-MOTD.Messages").size();
        int get = 0;
        if (!(p instanceof Player)) {
            p.sendMessage(this.plugin.getMessage("motdCommandInfoConsole"));
        }
        while (size > 0) {
            if (p instanceof Player) {
                Player player = (Player)p;
                p.sendMessage(((String)this.plugin.getConfig().getStringList("JoinGame-MOTD.Messages").get(get)).replace('&', '\u00a7').replace("{Player}", player.getName()).replace("{WorldTime}", "" + player.getWorld().getTime()));
            }
            if (!(p instanceof Player)) {
                p.sendMessage(((String)this.plugin.getConfig().getStringList("JoinGame-MOTD.Messages").get(get)).replace('&', '\u00a7'));
            }
            ++get;
            --size;
        }
    }

    @EventHandler
    public void serverListPingListener(ServerListPingEvent event) {
        if (this.plugin.getConfig().getBoolean("Server-MOTD.Enabled")) {
            Object e = null;
            if (!this.plugin.getConfig().getString("Server-MOTD.Line-1").isEmpty()) {
                e = this.plugin.getConfig().getString("Server-MOTD.Line-1").replace('&', '\u00a7').replace("{OnlinePlayers}", String.valueOf(this.plugin.getServer().getOnlinePlayers())).replace("{MaxPlayers}", "" + this.plugin.getServer().getMaxPlayers());
            }
            if (!this.plugin.getConfig().getString("Server-MOTD.Line-2").isEmpty()) {
                e = e + "\n" + this.plugin.getConfig().getString("Server-MOTD.Line-2").replace('&', '\u00a7');
            }
            event.setMotd("" + e);
        }
        if (this.plugin.getConfig().getBoolean("Custom-Server-Icon.Enabled")) {
            File motdConfigImage = new File(this.plugin.getDataFolder(), "server-icon.png");
            if (!motdConfigImage.exists()) {
                motdConfigImage.getParentFile().mkdirs();
                this.plugin.saveResource("server-icon.png", false);
            }
            try {
                event.setServerIcon(Bukkit.loadServerIcon((File)motdConfigImage));
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage("And error occurred while loading the server image file!");
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.plugin.getConfig().getBoolean("JoinGame-MOTD.Enabled")) {
            event.setJoinMessage("");
            int get = 0;
            for (int size = this.plugin.getConfig().getStringList("JoinGame-MOTD.Messages").size(); size > 0; --size) {
                event.getPlayer().sendMessage(((String)this.plugin.getConfig().getStringList("JoinGame-MOTD.Messages").get(get)).replace('&', '\u00a7').replace("{Player}", event.getPlayer().getName()).replace("{WorldTime}", "" + event.getPlayer().getWorld().getTime()));
                ++get;
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 1) {
            return Collections.emptyList();
        }
        return null;
    }
}

