/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class InventorySee
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public InventorySee(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("invsee")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("invsee")).setDescription(plugin.getMessage("inventorySeeCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("invsee")).setUsage(plugin.getMessage("inventorySeeCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (sender instanceof Player) {
            Player target;
            Player player = (Player)sender;
            if (args.length != 0) {
                target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    sender.sendMessage(this.plugin.getMessage("cannotFindPlayer"));
                    return true;
                }
                if (target == player) {
                    sender.sendMessage(this.plugin.getMessage("targetCannotBeYou"));
                    return true;
                }
                if (target.getGameMode() == GameMode.CREATIVE) {
                    sender.sendMessage(this.plugin.getMessage("inventorySeeCommandBuggyWarning"));
                    player.openInventory((Inventory)target.getInventory());
                    return true;
                }
            } else {
                return false;
            }
            sender.sendMessage(this.plugin.getMessage("inventorySeeYouOpenedTargetsInventory").replace("{0}", target.getName()));
            return true;
        }
        sender.sendMessage(this.plugin.getMessage("notAPlayer"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 2) {
            return Collections.emptyList();
        }
        return null;
    }
}

