/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Homes
implements CommandExecutor,
TabCompleter {
    final FileConfiguration homeConfig = new YamlConfiguration();
    final Main plugin;

    public Homes(Main plugin) {
        this.plugin = plugin;
        if (plugin.getConfig().getInt("MaxPlayerHomes") == 0) {
            Bukkit.getConsoleSender().sendMessage("\u00a74\u00a7lError, Configuration \"MaxPlayerHome\" must be greater than 0");
        }
        this.createHomesFile();
        this.load();
        plugin.getCommand("home").setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("home")).setDescription(plugin.getMessage("homeCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("home")).setUsage(plugin.getMessage("homeCommandUsage"));
        plugin.getCommand("sethome").setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("sethome")).setDescription(plugin.getMessage("setHomeCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("sethome")).setUsage(plugin.getMessage("setHomeCommandUsage"));
        plugin.getCommand("delhome").setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("delhome")).setDescription(plugin.getMessage("delHomeCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("delHome")).setUsage(plugin.getMessage("delHomeCommandUsage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        this.createHomesFile();
        this.load();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.homeConfig.getConfigurationSection("").contains("Homes.Players." + String.valueOf(player.getUniqueId()))) {
                this.homeConfig.createSection("Homes.Players." + String.valueOf(player.getUniqueId()));
                this.load();
            }
            switch (label) {
                case "homes": {
                    if (this.homeConfig.getConfigurationSection("Homes.Players." + String.valueOf(player.getUniqueId())).getKeys(false).size() != 0) {
                        sender.sendMessage(this.plugin.getMessage("homeCommandHereIsListOfHomes"));
                        this.listhomes(player);
                        return true;
                    }
                    sender.sendMessage(this.plugin.getMessage("homeCommandNoHomes"));
                    return true;
                }
                case "home": {
                    if (args.length >= 1) {
                        String homename = args[0];
                        this.checkifplayerhashome(player, homename);
                        return true;
                    }
                    if (this.homeConfig.getConfigurationSection("Homes.Players." + String.valueOf(player.getUniqueId())).getKeys(false).size() != 0) {
                        sender.sendMessage(this.plugin.getMessage("homeCommandHereIsListOfHomes"));
                        this.listhomes(player);
                        return true;
                    }
                    sender.sendMessage(this.plugin.getMessage("homeCommandNoHomes"));
                    return true;
                }
                case "sethome": 
                case "createhome": {
                    if (args.length >= 1) {
                        String homename = args[0];
                        if (this.homeConfig.getStringList("Homes.Players." + String.valueOf(player.getUniqueId())).contains(homename) || !this.homeConfig.getStringList("Homes.Players." + String.valueOf(player.getUniqueId())).isEmpty()) return true;
                        if (this.homeConfig.getConfigurationSection("Homes.Players." + String.valueOf(player.getUniqueId())).getKeys(false).size() <= this.plugin.getConfig().getInt("MaxPlayerHomes") - 1) {
                            this.addPlayerHome(player, homename);
                            return true;
                        }
                        sender.sendMessage(this.plugin.getMessage("homeCommandMaxHomesError"));
                        return true;
                    }
                    sender.sendMessage(this.plugin.getMessage("homeCommandEnterNameError"));
                    return true;
                }
                case "delhome": 
                case "remhome": 
                case "removehome": {
                    if (args.length >= 1) {
                        String homename = args[0];
                        this.removePlayerHome(player, homename);
                        return true;
                    }
                    sender.sendMessage(this.plugin.getMessage("homeCommandHereIsListOfHomes"));
                    this.listhomes(player);
                }
            }
            return true;
        } else {
            sender.sendMessage(this.plugin.getMessage("notAPlayer"));
        }
        return true;
    }

    private void createHomesFile() {
        File homeConfigFile = new File(this.plugin.getDataFolder(), "homes.yml");
        this.ifItExists();
        try {
            this.homeConfig.load(homeConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void addPlayerHome(Player p, String name) {
        if (this.homeConfig.contains("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name)) {
            p.sendMessage(this.plugin.getMessage("homeCommandHomeAlreadyExists").replace("{0}", name));
        } else {
            this.homeConfig.createSection("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name);
            this.homeConfig.createSection("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Enabled");
            this.homeConfig.createSection("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".X");
            this.homeConfig.createSection("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Y");
            this.homeConfig.createSection("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Z");
            int x = (int)p.getLocation().getX();
            int y = (int)p.getLocation().getY();
            int z = (int)p.getLocation().getZ();
            this.homeConfig.set("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Enabled", (Object)true);
            this.homeConfig.set("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".X", (Object)x);
            this.homeConfig.set("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Y", (Object)y);
            this.homeConfig.set("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Z", (Object)z);
            p.sendMessage(this.plugin.getMessage("homeCommandHomeCreated").replace("{0}", name).replace("{1}", "" + x).replace("{2}", "" + y).replace("{3}", "" + z));
            this.load();
        }
    }

    public void ifItExists() {
        File homeConfigFile = new File(this.plugin.getDataFolder(), "homes.yml");
        if (!homeConfigFile.exists()) {
            this.plugin.saveResource("homes.yml", true);
        }
    }

    public void removePlayerHome(Player p, String name) {
        if (!this.homeConfig.contains("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name)) {
            p.sendMessage(this.plugin.getMessage("homeCommandCouldNotFindHome").replace("{0}", name));
        } else {
            this.homeConfig.set("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name, null);
            p.sendMessage(this.plugin.getMessage("homeCommandRemovedHome").replace("{0}", name));
        }
        this.load();
    }

    public void listhomes(Player p) {
        StringJoiner message = new StringJoiner("\u00a72\u00a7l, ");
        for (String key : this.homeConfig.getConfigurationSection("Homes.Players." + String.valueOf(p.getUniqueId())).getKeys(false)) {
            message.add("\u00a7a\u00a7l" + key);
        }
        p.sendMessage(String.valueOf(message));
    }

    public void checkifplayerhashome(Player p, String name) {
        if (this.homeConfig.getBoolean("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Enabled")) {
            this.teleportplayertolocation(p, name);
        } else {
            p.sendMessage(this.plugin.getMessage("homeCommandCouldNotFindHome").replace("{0}", name));
        }
    }

    public void load() {
        File homeConfigFile = new File(this.plugin.getDataFolder(), "homes.yml");
        if (!homeConfigFile.exists()) {
            homeConfigFile.getParentFile().mkdirs();
            this.plugin.saveResource("homes.yml", false);
            Bukkit.getConsoleSender().sendMessage("\u00a74\u00a7lCould not save the file, is it being used by something?");
        }
        try {
            this.homeConfig.save(homeConfigFile);
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a74\u00a7lAn error occurred while reading your home.yml file, if you need help just join our discord with /betterserver help!");
        }
        try {
            this.homeConfig.load(homeConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            Bukkit.getConsoleSender().sendMessage("\u00a74\u00a7lAn error occurred while reading your home.yml file, if you need help just join our discord with /betterserver help!");
        }
    }

    public void teleportplayertolocation(Player p, String name) {
        this.load();
        World world = p.getWorld();
        int x = (Integer)this.homeConfig.get("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".X");
        int y = (Integer)this.homeConfig.get("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Y");
        int z = (Integer)this.homeConfig.get("Homes.Players." + String.valueOf(p.getUniqueId()) + "." + name + ".Z");
        p.teleport(new Location(world, (double)x, (double)y, (double)z));
        p.sendMessage(this.plugin.getMessage("homeCommandTeleportSuccess").replace("{0}", name));
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            if (!label.equals("homes")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (this.homeConfig.getStringList("Homes.Players").contains(String.valueOf(player.getUniqueId()))) {
                        ArrayList gethomes = Lists.newArrayList();
                        gethomes.addAll(this.homeConfig.getConfigurationSection("Homes.Players." + String.valueOf(player.getUniqueId())).getKeys(false));
                        return gethomes;
                    }
                    return Collections.emptyList();
                }
            } else {
                return Collections.emptyList();
            }
        }
        if (args.length >= 2) {
            return Collections.emptyList();
        }
        return null;
    }
}

