/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Gamemode
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public Gamemode(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("gamemode")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("gamemode")).setDescription(plugin.getMessage("gamemodeCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("gamemode")).setUsage(plugin.getMessage("gamemodeCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("gmc")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("gmc")).setDescription(plugin.getMessage("gmcCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("gmc")).setUsage(plugin.getMessage("gmcCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("gma")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("gma")).setDescription(plugin.getMessage("gmaCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("gma")).setUsage(plugin.getMessage("gmaCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("gms")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("gms")).setDescription(plugin.getMessage("gmsCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("gms")).setUsage(plugin.getMessage("gmsCommandUsage"));
        Objects.requireNonNull(this.plugin.getCommand("gmsp")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("gmsp")).setDescription(plugin.getMessage("gmspCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("gmsp")).setUsage(plugin.getMessage("gmspCommandUsage"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player target;
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        switch (label) {
            case "gmc": 
            case "gma": 
            case "gmsp": 
            case "gms": {
                Player target2;
                if (args.length == 0) {
                    Player player;
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(this.plugin.getMessage("gamemodeCommandEnterUser"));
                        return true;
                    }
                    target2 = player = (Player)sender;
                } else {
                    target2 = Bukkit.getPlayer((String)args[0]);
                }
                String gamemode = "";
                if (target2 == null) {
                    sender.sendMessage(this.plugin.getMessage("cannotFindPlayer").replace("{0}", args[0]));
                    return true;
                }
                switch (label) {
                    case "gmc": {
                        target2.setGameMode(GameMode.CREATIVE);
                        gamemode = "CREATIVE";
                        break;
                    }
                    case "gms": {
                        target2.setGameMode(GameMode.SURVIVAL);
                        gamemode = "SURVIVAL";
                        break;
                    }
                    case "gmsp": {
                        target2.setGameMode(GameMode.SPECTATOR);
                        gamemode = "SPECTATOR";
                        break;
                    }
                    case "gma": {
                        target2.setGameMode(GameMode.ADVENTURE);
                        gamemode = "ADVENTURE";
                        break;
                    }
                }
                if (target2 != sender) {
                    sender.sendMessage(this.plugin.getMessage("gamemodeCommandSetGamemodeTarget").replace("{0}", target2.getName()).replace("{1}", gamemode));
                }
                target2.sendMessage(this.plugin.getMessage("gamemodeCommandSetGamemodeUser").replace("{0}", gamemode));
                return true;
            }
        }
        if (args.length == 0) {
            return false;
        }
        String usage = args[0];
        if (args.length == 1) {
            Player player;
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessage("notAPlayer"));
                return true;
            }
            target = player = (Player)sender;
        } else {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.plugin.getMessage("cannotFindPlayer").replace("{0}", args[0]));
                return true;
            }
        }
        String gamemode = "";
        block25 : switch (cmd.getName()) {
            case "gamemode": 
            case "gm": {
                switch (usage) {
                    case "spectator": 
                    case "sp": 
                    case "4": {
                        target.setGameMode(GameMode.SPECTATOR);
                        gamemode = "SPECTATOR";
                        break block25;
                    }
                    case "adventure": 
                    case "av": 
                    case "a": 
                    case "3": {
                        target.setGameMode(GameMode.ADVENTURE);
                        gamemode = "ADVENTURE";
                        break block25;
                    }
                    case "survival": 
                    case "s": 
                    case "0": {
                        target.setGameMode(GameMode.SURVIVAL);
                        gamemode = "SURVIVAL";
                        break block25;
                    }
                    case "creative": 
                    case "c": 
                    case "1": {
                        target.setGameMode(GameMode.CREATIVE);
                        gamemode = "CREATIVE";
                        break block25;
                    }
                }
                sender.sendMessage(this.plugin.getMessage("gamemodeCommandCannotFindGamemode").replace("{0}", usage));
                return true;
            }
        }
        if (args.length != 1 && target != sender) {
            sender.sendMessage(this.plugin.getMessage("gamemodeCommandSetGamemodeTarget").replace("{0}", target.getName()).replace("{1}", gamemode));
        }
        target.sendMessage(this.plugin.getMessage("gamemodeCommandSetGamemodeUser").replace("{0}", gamemode));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            switch (label) {
                case "gm": 
                case "gamemode": {
                    ArrayList getgamemode = Lists.newArrayList();
                    getgamemode.add("creative");
                    getgamemode.add("survival");
                    getgamemode.add("spectator");
                    getgamemode.add("adventure");
                    return getgamemode;
                }
            }
        }
        if (args.length >= 2) {
            switch (label) {
                case "gmc": 
                case "gms": 
                case "gmsp": 
                case "gma": {
                    return Collections.emptyList();
                }
            }
        }
        if (args.length >= 3) {
            return Collections.emptyList();
        }
        return null;
    }
}

