/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Fly
implements CommandExecutor,
TabCompleter {
    final Main plugin;

    public Fly(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("fly")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("fly")).setDescription(plugin.getMessage("flyCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("fly")).setUsage(plugin.getMessage("flyCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                if (!player.getAllowFlight()) {
                    player.setAllowFlight(true);
                    sender.sendMessage(this.plugin.getMessage("flightEnabledForPlayer"));
                } else {
                    player.setAllowFlight(false);
                    sender.sendMessage(this.plugin.getMessage("flightDisabledForPlayer"));
                }
            }
            if (args.length >= 1) {
                Player other = Bukkit.getPlayer((String)args[0]);
                if (other != null) {
                    if (!other.getAllowFlight()) {
                        other.setAllowFlight(true);
                        sender.sendMessage(this.plugin.getMessage("flightEnabledForTarget").replace("{0}", other.getName()));
                    } else {
                        other.setAllowFlight(false);
                        sender.sendMessage(this.plugin.getMessage("flightDisabledForTarget").replace("{0}", other.getName()));
                    }
                } else {
                    sender.sendMessage(this.plugin.getMessage("cannotFindPlayer").replace("{0}", args[0]));
                }
            }
        } else {
            sender.sendMessage(this.plugin.getMessage("notAPlayer"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 2) {
            return Collections.emptyList();
        }
        return null;
    }
}

