/*
 * Decompiled with CFR 0.152.
 */
package BetterServer.commands;

import BetterServer.Main;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;

public class BetterServerHelper
implements CommandExecutor,
TabCompleter,
Listener {
    final Main plugin;

    public BetterServerHelper(Main plugin) {
        this.plugin = plugin;
        Objects.requireNonNull(this.plugin.getCommand("BetterServer")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand("BetterServer")).setDescription(plugin.getMessage("betterServerCommandDescription"));
        Objects.requireNonNull(this.plugin.getCommand("BetterServer")).setUsage(plugin.getMessage("betterServerCommandUsage"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getConfig().getStringList("DisabledCommands").contains(label)) {
            sender.sendMessage(this.plugin.getMessage("commandDisabled"));
            return true;
        }
        if (args.length >= 1) {
            String usage;
            block6 : switch (usage = args[0]) {
                case "help": {
                    sender.sendMessage(this.plugin.getMessage("betterServerCommandHelp"));
                    break;
                }
                case "update": {
                    sender.sendMessage(this.plugin.getMessage("betterServerCommandUpdate"));
                    this.plugin.updateversion();
                    break;
                }
                case "reload": {
                    File spawnConfigFile;
                    this.plugin.reloadConfig();
                    this.plugin.updateversion();
                    this.plugin.LanguageUtil();
                    File homeConfigFile = new File(this.plugin.getDataFolder(), "homes.yml");
                    if (!homeConfigFile.exists()) {
                        homeConfigFile.getParentFile().mkdirs();
                        this.plugin.saveResource("homes.yml", false);
                    }
                    if (!(spawnConfigFile = new File(this.plugin.getDataFolder(), "spawn.yml")).exists()) {
                        spawnConfigFile.getParentFile().mkdirs();
                        this.plugin.saveResource("spawn.yml", false);
                    }
                    sender.sendMessage(this.plugin.getMessage("betterServerCommandReloadComplete"));
                    break;
                }
                case "language": {
                    if (args.length >= 2) {
                        switch (args[1]) {
                            case "en": 
                            case "english": {
                                this.plugin.getConfig().getConfigurationSection("").set("Language", (Object)"en");
                                this.plugin.saveConfig();
                                sender.sendMessage(this.plugin.getMessage("betterServerlanguageSetToEN"));
                                break block6;
                            }
                            case "es": {
                                this.plugin.getConfig().getConfigurationSection("").set("Language", (Object)"es");
                                this.plugin.saveConfig();
                                sender.sendMessage(this.plugin.getMessage("betterServerlanguageSetToES"));
                                break block6;
                            }
                            case "fr": {
                                this.plugin.getConfig().getConfigurationSection("").set("Language", (Object)"fr");
                                this.plugin.saveConfig();
                                sender.sendMessage(this.plugin.getMessage("betterServerlanguageSetToFR"));
                                break block6;
                            }
                        }
                        sender.sendMessage(this.plugin.getMessage("languageCommandCannotFindLanguage").replace("{0}", args[0]));
                        break;
                    }
                    sender.sendMessage(this.plugin.getMessage("betterServerLanguageNoArgs").replace("{0}", this.plugin.getConfig().getString("Language")));
                    break;
                }
                default: {
                    sender.sendMessage(this.plugin.getMessage("betterServerCommandCannotFindOption"));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            ArrayList setList = Lists.newArrayList();
            setList.add("help");
            setList.add("update");
            setList.add("reload");
            setList.add("language");
            return setList;
        }
        if (args.length == 2) {
            if (args[0].equals("language")) {
                ArrayList list = Lists.newArrayList();
                list.add("en");
                list.add("es");
                list.add("fr");
                return list;
            }
            return Collections.emptyList();
        }
        if (args.length >= 3) {
            return Collections.emptyList();
        }
        return null;
    }
}

