/*
 * Decompiled with CFR 0.152.
 */
package events;

import better.gold.lidle.BetterGold;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import spawners.SpawnerUtil;

public class GoldPickaxeEvent
implements Listener {
    BetterGold betterGold;
    public static boolean isEnabled = true;
    public static boolean mineSpawners = true;
    public static boolean silkTouchNeeded = false;

    public GoldPickaxeEvent(BetterGold plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.betterGold = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (isEnabled && e.getBlock().getType() == Material.MOB_SPAWNER) {
            Block block = e.getBlock();
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
            EntityType type = SpawnerUtil.getTypeFromString(item);
            CreatureSpawner spawner = (CreatureSpawner)block.getState();
            spawner.setSpawnedType(type);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getPlayer().getInventory().getItemInMainHand().getType() == Material.GOLD_PICKAXE) {
            if (isEnabled) {
                Player p = e.getPlayer();
                ItemStack item = p.getInventory().getItemInMainHand();
                Block block = e.getBlock();
                Location loc = block.getLocation();
                Material material = block.getType();
                World world = block.getWorld();
                if (material == Material.IRON_ORE) {
                    GoldPickaxeEvent.dropItem(world, loc, block, Material.IRON_INGOT, 1, e);
                }
                if (material == Material.GOLD_ORE) {
                    GoldPickaxeEvent.dropItem(world, loc, block, Material.GOLD_INGOT, 1, e);
                }
                if (material == Material.COAL_ORE) {
                    GoldPickaxeEvent.dropItem(world, loc, block, Material.COAL, 1, e);
                }
                if (material == Material.STONE) {
                    GoldPickaxeEvent.dropItem(world, loc, block, Material.STONE, 1, e);
                }
                if (p.hasPermission(BetterGold.mineSpawnerPermission_) && mineSpawners && !silkTouchNeeded) {
                    if (material == Material.MOB_SPAWNER) {
                        this.dropSpawner(block, e);
                    } else if (silkTouchNeeded && material == Material.MOB_SPAWNER && item.containsEnchantment(Enchantment.SILK_TOUCH)) {
                        this.dropSpawner(block, e);
                    }
                }
                item.setDurability((short)(item.getDurability() + 1));
            }
        } else {
            return;
        }
    }

    private void dropSpawner(Block block, BlockBreakEvent e) {
        Location loc = block.getLocation();
        e.setExpToDrop(0);
        CreatureSpawner creatureSpawner = (CreatureSpawner)block.getState();
        String type = creatureSpawner.getCreatureTypeName();
        ItemStack spawner = this.createSpawner(type);
        block.getWorld().dropItemNaturally(loc, spawner);
    }

    public static void dropItem(World world, Location loc, Block block, Material material, int amt, BlockBreakEvent e) {
        world.dropItemNaturally(loc, new ItemStack(material, amt));
        block.setType(Material.AIR);
        e.setCancelled(true);
    }

    public ItemStack createSpawner(String type) {
        ItemStack spawnerItem = new ItemStack(Material.MOB_SPAWNER);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GOLD + type + " Spawner");
        ItemMeta meta = spawnerItem.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_PURPLE + type + " Spawner");
        meta.setLore(lore);
        spawnerItem.setItemMeta(meta);
        return spawnerItem;
    }
}

