/*
 * Decompiled with CFR 0.152.
 */
package events;

import better.gold.lidle.BetterGold;
import events.GoldArmorEvent;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityMountEvent;

public class GoldHorseArmorEvent
implements Listener {
    BetterGold betterGold;
    public static boolean isEnabled = true;
    public static boolean lightningStruck = false;
    public static int morphChance;

    public GoldHorseArmorEvent(BetterGold plugin) {
        this.betterGold = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.validateMorph();
    }

    @EventHandler
    public void onEntityMount(EntityMountEvent e) {
        Entity horse = e.getMount();
        Entity player = e.getEntity();
        if (!(horse instanceof Horse) || !(player instanceof Player)) {
            return;
        }
        horse = (Horse)e.getMount();
        player = (Player)e.getEntity();
        Location loc = horse.getLocation();
        horse.getWorld().playSound(loc, Sound.ENTITY_DONKEY_CHEST, 1.0f, 1.0f);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Horse horse;
        Player p = e.getPlayer();
        if (p.isInsideVehicle() && p.getVehicle() instanceof Horse && (horse = (Horse)p.getVehicle()).getInventory().contains(Material.GOLD_BARDING)) {
            this.generateParticles(e);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Player && e.getEntity() instanceof Horse) {
            Horse horse = (Horse)e.getEntity();
            Random rand = new Random();
            if (GoldArmorEvent.isEnabled && lightningStruck) {
                int morphChance_ = rand.nextInt(100) + 0;
                if (horse.isTamed() && morphChance_ <= morphChance) {
                    horse.getInventory().clear();
                    horse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
                    horse.setVariant(Horse.Variant.SKELETON_HORSE);
                }
                lightningStruck = false;
            }
        } else {
            return;
        }
    }

    private void generateParticles(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        Location loc = p.getLocation();
        World world = p.getWorld();
        world.spawnParticle(Particle.LAVA, loc, 2);
        world.spawnParticle(Particle.ENCHANTMENT_TABLE, loc, 6);
    }

    private void validateMorph() {
        if (morphChance < 0) {
            morphChance = 0;
            this.betterGold.getLogger().info("Morph chance to low! Setting to 0%");
            this.betterGold.getLogger().info("Only accepts #s between 0 and 100!");
        }
        if (morphChance > 100) {
            morphChance = 100;
            this.betterGold.getLogger().info("Morph chance to high! Setting to 100%");
            this.betterGold.getLogger().info("Only accepts #s between 0 and 100!");
        }
    }
}

