/*
 * Decompiled with CFR 0.152.
 */
package events;

import better.gold.lidle.BetterGold;
import events.GoldPickaxeEvent;
import hoe.blocks.HoeBlockType;
import hoe.blocks.HoeDrops;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class GoldHoeEvent
implements Listener {
    BetterGold betterGold;
    private static final String PLAYER_PLACED = "playerPlaced";
    private static int dropRates = 2;
    private List<Material> materialList = new ArrayList<Material>();
    public static boolean doubleDrops = false;
    public static boolean isEnabled = true;

    public GoldHoeEvent(BetterGold plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.initList();
        this.betterGold = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        String type = e.getBlock().getType().toString();
        Block block = e.getBlock();
        if (type.equalsIgnoreCase(Material.MELON_BLOCK.toString()) || type.equalsIgnoreCase(Material.PUMPKIN.toString())) {
            block.setMetadata(PLAYER_PLACED, (MetadataValue)new FixedMetadataValue((Plugin)this.betterGold, (Object)true));
            return;
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getPlayer().getItemInHand().getType() == Material.GOLD_HOE) {
            if (isEnabled) {
                ItemStack item = e.getPlayer().getInventory().getItemInHand();
                Block block = e.getBlock();
                Material blockType = block.getType();
                boolean isPlaced = block.hasMetadata(PLAYER_PLACED);
                if (isPlaced && !this.materialList.contains(blockType)) {
                    return;
                }
                HoeBlockType[] hoeBlockTypeArray = HoeBlockType.values();
                int n = hoeBlockTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HoeBlockType types = hoeBlockTypeArray[n2];
                    if (blockType.toString().equalsIgnoreCase(types.type())) {
                        GoldHoeEvent.dropBlock(block, blockType, e);
                    }
                    ++n2;
                }
                int durability = item.getDurability() + 1;
                item.setDurability((short)durability);
                if (e.getPlayer().getInventory().getItemInMainHand().getDurability() >= 33) {
                    e.getPlayer().getInventory().remove(e.getPlayer().getInventory().getItemInMainHand());
                }
            }
        } else {
            return;
        }
    }

    public static void dropBlock(Block block, Material mat, BlockBreakEvent e) {
        switch (mat) {
            case LEAVES: {
                HoeDrops.leavesDrop(block, e);
                break;
            }
            case MELON_BLOCK: {
                HoeDrops.melonBlockDrop(block, e);
                break;
            }
            case CROPS: {
                HoeDrops.wheatDrop(block, e);
                break;
            }
            case CARROT: {
                HoeDrops.carrotPotatoDrop(block, e);
                break;
            }
            case POTATO: {
                HoeDrops.carrotPotatoDrop(block, e);
                break;
            }
            case PUMPKIN: {
                HoeDrops.pumpkinBlockDrop(block, e);
                break;
            }
            case NETHER_WARTS: {
                HoeDrops.netherWartDrop(block, e);
                break;
            }
            default: {
                GoldPickaxeEvent.dropItem(block.getWorld(), block.getLocation(), block, mat, dropRates, e);
            }
        }
    }

    private void initList() {
        this.materialList.add(Material.CARROT);
        this.materialList.add(Material.CROPS);
        this.materialList.add(Material.POTATO);
        this.materialList.add(Material.NETHER_WART_BLOCK);
    }
}

