/*
 * Decompiled with CFR 0.152.
 */
package events;

import better.gold.lidle.BetterGold;
import events.GoldHorseArmorEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class GoldArmorEvent
implements Listener {
    public static boolean isEnabled = true;
    public static boolean offensiveLightningEnabled;
    public static boolean defensiveLightningEnabled;
    BetterGold betterGold;
    private List<Material> materialList = new ArrayList<Material>();
    private List<Material> armorContents = new ArrayList<Material>();

    public GoldArmorEvent(BetterGold plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.betterGold = plugin;
        this.initList();
        defensiveLightningEnabled = plugin.getConfig().getBoolean("defensive-lightning-enabled");
        offensiveLightningEnabled = plugin.getConfig().getBoolean("offensive-lightning-enabled");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (!isEnabled) return;
        if (e.getDamager() instanceof Player && this.validEntity(e) && offensiveLightningEnabled) {
            Player p = (Player)e.getDamager();
            if (!this.hasGoldArmor(p)) return;
            Entity entity = e.getEntity();
            this.offensiveLightning(p, entity);
            return;
        } else {
            if (!(e.getDamager() instanceof Monster) || !(e.getEntity() instanceof Player) || !defensiveLightningEnabled) return;
            Player p = (Player)e.getEntity();
            if (!this.hasGoldArmor(p)) return;
            Entity entity = e.getDamager();
            this.defensiveLightning(p, entity);
        }
    }

    private void defensiveLightning(Player p, Entity entity) {
        Random rand = new Random();
        int strikeChance = rand.nextInt(10) + 1;
        if (strikeChance == 5) {
            p.setInvulnerable(true);
            if (p.isInvulnerable()) {
                entity.getWorld().strikeLightning(entity.getLocation());
            }
            this.wait(p);
        }
    }

    private void offensiveLightning(Player p, Entity entity) {
        Random rand = new Random();
        int strikeChance = rand.nextInt(10) + 1;
        if (strikeChance == 5) {
            GoldHorseArmorEvent.lightningStruck = true;
            p.setInvulnerable(true);
            if (p.isInvulnerable()) {
                entity.getWorld().strikeLightning(entity.getLocation());
            }
            this.wait(p);
        }
    }

    private void wait(final Player p) {
        Bukkit.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.betterGold, new Runnable(){

            @Override
            public void run() {
                p.setInvulnerable(false);
            }
        }, 20L);
    }

    private void initList() {
        this.materialList.add(Material.GOLD_HELMET);
        this.materialList.add(Material.GOLD_CHESTPLATE);
        this.materialList.add(Material.GOLD_LEGGINGS);
        this.materialList.add(Material.GOLD_BOOTS);
    }

    private boolean hasGoldArmor(Player p) {
        if (p.getInventory().getHelmet() == null) {
            return false;
        }
        Material helm = p.getInventory().getHelmet().getType();
        this.armorContents.add(helm);
        if (p.getInventory().getChestplate() == null) {
            return false;
        }
        Material chest = p.getInventory().getChestplate().getType();
        this.armorContents.add(chest);
        if (p.getInventory().getLeggings() == null) {
            return false;
        }
        Material leggings = p.getInventory().getLeggings().getType();
        this.armorContents.add(leggings);
        if (p.getInventory().getBoots() == null) {
            return false;
        }
        Material boots = p.getInventory().getBoots().getType();
        this.armorContents.add(boots);
        return this.materialList.containsAll(this.armorContents);
    }

    private boolean validEntity(EntityDamageByEntityEvent e) {
        return e.getEntity() instanceof Monster || e.getEntity() instanceof Animals;
    }
}

