/*
 * Decompiled with CFR 0.152.
 */
package com.github.cheesesoftware.BetterBlockBreaking;

import com.github.cheesesoftware.BetterBlockBreaking.BetterBlockBreaking;
import com.github.cheesesoftware.BetterBlockBreaking.DamageBlock;
import java.util.Date;
import net.minecraft.server.v1_10_R1.Block;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.EntityHuman;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.IBlockData;
import net.minecraft.server.v1_10_R1.World;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShowCurrentBlockDamageTask
extends BukkitRunnable {
    private final Player p;
    private final DamageBlock damageBlock;

    public ShowCurrentBlockDamageTask(Player p, DamageBlock damageBlock) {
        this.p = p;
        this.damageBlock = damageBlock;
    }

    public void run() {
        if (this.p.hasMetadata("BlockBeginDestroy")) {
            Date old = (Date)((MetadataValue)this.p.getMetadata("BlockBeginDestroy").get(0)).value();
            Date now = new Date();
            long differenceMilliseconds = now.getTime() - old.getTime();
            WorldServer world = ((CraftWorld)this.p.getWorld()).getHandle();
            EntityPlayer player = ((CraftPlayer)this.p).getHandle();
            BlockPosition pos = new BlockPosition(this.damageBlock.getX(), this.damageBlock.getY(), this.damageBlock.getZ());
            IBlockData blockData = world.getType(pos);
            Block block = blockData.getBlock();
            float i = differenceMilliseconds / 20L;
            float f = 1000.0f * (block.getDamage(blockData, (EntityHuman)player, (World)world, pos) * i / 240.0f);
            this.damageBlock.setDamage(f += this.damageBlock.getDamage(), this.p);
            this.p.setMetadata("BlockBeginDestroy", (MetadataValue)new FixedMetadataValue((Plugin)BetterBlockBreaking.getPlugin(), (Object)new Date()));
        } else {
            this.cancel();
        }
    }
}

