/*
 * Decompiled with CFR 0.152.
 */
package com.github.cheesesoftware.BetterBlockBreaking;

import com.github.cheesesoftware.BetterBlockBreaking.BetterBlockBreaking;
import com.github.cheesesoftware.BetterBlockBreaking.DamageBlock;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_10_R1.CraftServer;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.scheduler.BukkitRunnable;

public class RemoveOldDamagedBlocksTask
extends BukkitRunnable {
    private final BetterBlockBreaking plugin;
    public static long millisecondsBeforeBeginFade = 120000L;
    public static long millisecondsBetweenFade = 2000L;
    public static int damageDecreasePerFade = 1;

    public RemoveOldDamagedBlocksTask(BetterBlockBreaking plugin) {
        this.plugin = plugin;
    }

    public void run() {
        HashMap<Location, DamageBlock> damagedBlocks = new HashMap<Location, DamageBlock>(this.plugin.damageBlocks);
        Iterator<Map.Entry<Location, DamageBlock>> it = damagedBlocks.entrySet().iterator();
        while (it.hasNext()) {
            long elapsedMilliseconds;
            Map.Entry<Location, DamageBlock> current = it.next();
            DamageBlock damageBlock = current.getValue();
            Date dateModified = damageBlock.getDamageDate();
            Date dateLastFade = damageBlock.getLastFadeDate();
            boolean remove = false;
            if (dateLastFade != null) {
                elapsedMilliseconds = new Date().getTime() - dateLastFade.getTime();
                if (elapsedMilliseconds >= millisecondsBetweenFade) {
                    damageBlock.setLastFadeDate();
                    remove = this.fadeBlock(damageBlock);
                }
            } else if (dateModified != null) {
                elapsedMilliseconds = new Date().getTime() - dateModified.getTime();
                if (elapsedMilliseconds >= millisecondsBeforeBeginFade) {
                    damageBlock.setLastFadeDate();
                    remove = this.fadeBlock(damageBlock);
                }
            } else {
                remove = true;
            }
            if (!remove) continue;
            it.remove();
        }
        this.plugin.damageBlocks = damagedBlocks;
    }

    private boolean fadeBlock(DamageBlock damageBlock) {
        float damage;
        BlockPosition pos;
        if (damageBlock.isDamaged()) {
            pos = new BlockPosition(damageBlock.getX(), damageBlock.getY(), damageBlock.getZ());
            damage = damageBlock.getDamage();
            if ((damage -= (float)damageDecreasePerFade) <= 0.0f) {
                damageBlock.removeAllDamage();
                return true;
            }
            damageBlock.setDamage(damage, null);
            if (damageBlock.getEntity() == null) {
                return true;
            }
        } else {
            return true;
        }
        WorldServer world = ((CraftWorld)damageBlock.getWorld()).getHandle();
        ((CraftServer)Bukkit.getServer()).getHandle().sendPacketNearby(null, (double)damageBlock.getX(), (double)damageBlock.getY(), (double)damageBlock.getZ(), 120.0, world.dimension, (Packet)new PacketPlayOutBlockBreakAnimation(damageBlock.getEntity().getId(), pos, (int)damage));
        return false;
    }
}

