/*
 * Decompiled with CFR 0.152.
 */
package com.github.cheesesoftware.BetterBlockBreaking;

import com.github.cheesesoftware.BetterBlockBreaking.BetterBlockBreaking;
import com.github.cheesesoftware.BetterBlockBreaking.KeepBlockDamageAliveTask;
import java.lang.reflect.Field;
import java.util.Date;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.Entity;
import net.minecraft.server.v1_10_R1.EntityChicken;
import net.minecraft.server.v1_10_R1.EntityLiving;
import net.minecraft.server.v1_10_R1.IBlockData;
import net.minecraft.server.v1_10_R1.MinecraftKey;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_10_R1.PacketPlayOutBlockChange;
import net.minecraft.server.v1_10_R1.SoundEffect;
import net.minecraft.server.v1_10_R1.SoundEffectType;
import net.minecraft.server.v1_10_R1.TileEntity;
import net.minecraft.server.v1_10_R1.World;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_10_R1.CraftServer;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DamageBlock {
    private Location l;
    private Date dateDamaged = null;
    private Date lastFade = null;
    private float damage = 0.0f;
    private EntityLiving entity = null;
    public boolean isNoCancel = false;
    public int keepBlockDamageAliveTaskId = -1;

    public DamageBlock(Location l) {
        this.l = l;
    }

    public Location getLocation() {
        return this.l;
    }

    public Date getDamageDate() {
        return this.dateDamaged;
    }

    public Date getLastFadeDate() {
        return this.lastFade;
    }

    public void resetFade() {
        this.dateDamaged = null;
        this.lastFade = null;
    }

    public EntityLiving getEntity() {
        return this.entity;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isDamaged() {
        return this.damage > 0.0f;
    }

    public org.bukkit.World getWorld() {
        return this.l.getWorld();
    }

    public int getX() {
        return this.l.getBlockX();
    }

    public int getY() {
        return this.l.getBlockY();
    }

    public int getZ() {
        return this.l.getBlockZ();
    }

    private void setDamageDate() {
        this.dateDamaged = new Date();
    }

    public void setLastFadeDate() {
        this.lastFade = new Date();
    }

    public void setDamage(float damage, Player breaker) {
        this.damage = damage;
        this.setDamageDate();
        WorldServer world = ((CraftWorld)this.l.getWorld()).getHandle();
        BlockPosition pos = new BlockPosition(this.getX(), this.getY(), this.getZ());
        IBlockData blockData = world.getType(pos);
        if (damage >= 10.0f || damage > 0.0f && blockData.getBlock().b(blockData, (World)world, pos) <= 0.0f) {
            this.breakBlock(breaker);
            return;
        }
        if (damage <= 0.0f) {
            damage = -1.0f;
        }
        if (this.entity == null) {
            this.entity = new EntityChicken((World)world);
            world.addEntity((Entity)this.entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        if (!this.isNoCancel) {
            ((CraftServer)Bukkit.getServer()).getHandle().sendPacketNearby(null, (double)this.getX(), (double)this.getY(), (double)this.getZ(), 120.0, world.dimension, (Packet)new PacketPlayOutBlockBreakAnimation(this.entity.getId(), pos, (int)this.damage));
        }
        if (this.keepBlockDamageAliveTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.keepBlockDamageAliveTaskId);
        }
        BukkitTask aliveTask = new KeepBlockDamageAliveTask(BetterBlockBreaking.getPlugin(), this).runTaskTimer((Plugin)BetterBlockBreaking.getPlugin(), BetterBlockBreaking.blockDamageUpdateDelay, BetterBlockBreaking.blockDamageUpdateDelay);
        this.keepBlockDamageAliveTaskId = aliveTask.getTaskId();
    }

    public void breakBlock(Player breaker) {
        Block block = this.l.getBlock();
        if (breaker != null) {
            WorldServer world = ((CraftWorld)this.l.getWorld()).getHandle();
            BlockPosition pos = new BlockPosition(this.getX(), this.getY(), this.getZ());
            if (block.getType() != Material.AIR) {
                BlockBreakEvent event = new BlockBreakEvent(block, breaker);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    ((CraftPlayer)breaker).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutBlockChange((World)world, pos));
                    TileEntity tileentity = world.getTileEntity(pos);
                    if (tileentity != null) {
                        ((CraftPlayer)breaker).getHandle().playerConnection.sendPacket((Packet)tileentity.getUpdatePacket());
                    }
                    this.removeAllDamage();
                } else {
                    this.removeAllDamage();
                    try {
                        Field f = SoundEffectType.class.getDeclaredField("o");
                        f.setAccessible(true);
                        SoundEffect soundEffect = (SoundEffect)f.get(world.getType(pos).getBlock().w());
                        Field f2 = SoundEffect.class.getDeclaredField("b");
                        f2.setAccessible(true);
                        MinecraftKey minecraftKey = (MinecraftKey)f2.get(soundEffect);
                        String sound = minecraftKey.a();
                        breaker.getWorld().playSound(new Location(breaker.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), sound, 2.0f, 1.0f);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ((CraftPlayer)breaker).getHandle().playerInteractManager.breakBlock(pos);
                }
            }
        } else {
            block.setType(Material.AIR);
            this.removeAllDamage();
        }
    }

    public void removeAllDamage() {
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        BlockPosition pos = new BlockPosition(this.getX(), this.getY(), this.getZ());
        if (this.keepBlockDamageAliveTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.keepBlockDamageAliveTaskId);
        }
        if (this.entity == null) {
            this.entity = new EntityChicken((World)world);
            world.addEntity((Entity)this.entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        ((CraftServer)Bukkit.getServer()).getHandle().sendPacketNearby(null, (double)this.getX(), (double)this.getY(), (double)this.getZ(), 120.0, world.dimension, (Packet)new PacketPlayOutBlockBreakAnimation(this.getEntity().getId(), pos, -1));
        this.getEntity().die();
        BetterBlockBreaking.getPlugin().damageBlocks.remove(this.getLocation());
    }

    public void setEntity(EntityLiving entity) {
        this.entity = entity;
    }
}

