/*
 * Decompiled with CFR 0.152.
 */
package com.github.cheesesoftware.BetterBlockBreaking;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.github.cheesesoftware.BetterBlockBreaking.DamageBlock;
import com.github.cheesesoftware.BetterBlockBreaking.KeepBlockDamageAliveTask;
import com.github.cheesesoftware.BetterBlockBreaking.RemoveOldDamagedBlocksTask;
import com.github.cheesesoftware.BetterBlockBreaking.ShowCurrentBlockDamageTask;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.Entity;
import net.minecraft.server.v1_10_R1.EntityChicken;
import net.minecraft.server.v1_10_R1.EntityLiving;
import net.minecraft.server.v1_10_R1.EntityTNTPrimed;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayInBlockDig;
import net.minecraft.server.v1_10_R1.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_10_R1.World;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_10_R1.CraftServer;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BetterBlockBreaking
extends JavaPlugin
implements Listener {
    public static int blockDamageUpdateDelay = 100;
    private ProtocolManager protocolManager;
    private int removeOldDamagedBlocksTaskId = -1;
    private boolean useCustomExplosions = true;
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;
    public Plugin worldGuard = null;
    public HashMap<Location, DamageBlock> damageBlocks = new HashMap();

    public void onEnable() {
        this.worldGuard = this.getWorldGuard();
        this.saveDefaultConfig();
        this.reloadCustomConfig();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        BukkitTask task = new RemoveOldDamagedBlocksTask(this).runTaskTimer((Plugin)this, 0L, 20L);
        this.removeOldDamagedBlocksTaskId = task.getTaskId();
    }

    public void onLoad() {
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

            public void onPacketReceiving(PacketEvent e) {
                if (e.getPacketType() == PacketType.Play.Client.BLOCK_DIG) {
                    final PacketContainer packet = e.getPacket();
                    final PacketEvent event = e;
                    final HashMap<Location, DamageBlock> damageBlocks = ((BetterBlockBreaking)this.plugin).damageBlocks;
                    BukkitRunnable runnable = new BukkitRunnable(){

                        public void run() {
                            StructureModifier data = packet.getSpecificModifier(PacketPlayInBlockDig.EnumPlayerDigType.class);
                            StructureModifier dataTemp = packet.getSpecificModifier(BlockPosition.class);
                            PacketPlayInBlockDig.EnumPlayerDigType type = (PacketPlayInBlockDig.EnumPlayerDigType)data.getValues().get(0);
                            Player p = event.getPlayer();
                            BlockPosition pos = (BlockPosition)dataTemp.getValues().get(0);
                            Location posLocation = new Location(p.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                            if ((this).BetterBlockBreaking.this.worldGuard != null && !((WorldGuardPlugin)(this).BetterBlockBreaking.this.worldGuard).canBuild(p, posLocation)) {
                                return;
                            }
                            if (p.getGameMode() == GameMode.SURVIVAL) {
                                DamageBlock damageBlock = (DamageBlock)damageBlocks.get(posLocation);
                                if (damageBlock == null) {
                                    damageBlock = new DamageBlock(posLocation);
                                    damageBlocks.put(posLocation, damageBlock);
                                }
                                if (type == PacketPlayInBlockDig.EnumPlayerDigType.START_DESTROY_BLOCK) {
                                    p.setMetadata("BlockBeginDestroy", (MetadataValue)new FixedMetadataValue(plugin, (Object)new Date()));
                                    if (p.hasMetadata("showCurrentDamageTaskId")) {
                                        Bukkit.getScheduler().cancelTask(((MetadataValue)p.getMetadata("showCurrentDamageTaskId").get(0)).asInt());
                                        p.removeMetadata("showCurrentDamageTaskId", plugin);
                                    }
                                    damageBlock.resetFade();
                                    if (!damageBlock.isDamaged()) {
                                        damageBlock.isNoCancel = true;
                                    }
                                    BukkitTask task = new ShowCurrentBlockDamageTask(p, damageBlock).runTaskTimer(plugin, 0L, 2L);
                                    p.setMetadata("showCurrentDamageTaskId", (MetadataValue)new FixedMetadataValue(plugin, (Object)task.getTaskId()));
                                } else if (type == PacketPlayInBlockDig.EnumPlayerDigType.ABORT_DESTROY_BLOCK || type == PacketPlayInBlockDig.EnumPlayerDigType.STOP_DESTROY_BLOCK) {
                                    if (p.hasMetadata("showCurrentDamageTaskId")) {
                                        Bukkit.getScheduler().cancelTask(((MetadataValue)p.getMetadata("showCurrentDamageTaskId").get(0)).asInt());
                                        p.removeMetadata("showCurrentDamageTaskId", plugin);
                                    }
                                    if (damageBlock.isNoCancel && type == PacketPlayInBlockDig.EnumPlayerDigType.ABORT_DESTROY_BLOCK) {
                                        WorldServer world = ((CraftWorld)damageBlock.getWorld()).getHandle();
                                        EntityLiving entity = damageBlock.getEntity();
                                        if (entity == null) {
                                            entity = new EntityChicken((World)world);
                                            world.addEntity((Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                                            damageBlock.setEntity(entity);
                                        }
                                        float currentDamage = damageBlock.getDamage();
                                        ((CraftServer)plugin.getServer()).getHandle().sendPacketNearby(null, posLocation.getX(), posLocation.getY(), posLocation.getZ(), 120.0, world.dimension, (Packet)new PacketPlayOutBlockBreakAnimation(damageBlock.getEntity().getId(), pos, (int)currentDamage));
                                        if (damageBlock.keepBlockDamageAliveTaskId != -1) {
                                            Bukkit.getScheduler().cancelTask(damageBlock.keepBlockDamageAliveTaskId);
                                            damageBlock.keepBlockDamageAliveTaskId = -1;
                                        }
                                        BukkitTask aliveTask = new KeepBlockDamageAliveTask((JavaPlugin)plugin, damageBlock).runTaskTimer(plugin, blockDamageUpdateDelay, blockDamageUpdateDelay);
                                        damageBlock.keepBlockDamageAliveTaskId = aliveTask.getTaskId();
                                    }
                                    damageBlock.isNoCancel = false;
                                    p.removeMetadata("BlockBeginDestroy", plugin);
                                }
                            }
                        }
                    };
                    runnable.runTaskLater(this.plugin, 0L);
                }
            }
        });
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.removeOldDamagedBlocksTaskId);
    }

    public void reloadCustomConfig() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.getDataFolder(), "config.yml");
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
        if (this.customConfig.contains("millisecondsBeforeBeginFade")) {
            RemoveOldDamagedBlocksTask.millisecondsBeforeBeginFade = this.customConfig.getLong("millisecondsBeforeBeginFade");
        }
        if (this.customConfig.contains("millisecondsBetweenFade")) {
            RemoveOldDamagedBlocksTask.millisecondsBetweenFade = this.customConfig.getLong("millisecondsBetweenFade");
        }
        if (this.customConfig.contains("damageDecreasePerFade")) {
            RemoveOldDamagedBlocksTask.damageDecreasePerFade = this.customConfig.getInt("damageDecreasePerFade");
        }
        if (this.customConfig.contains("useCustomExplosions")) {
            this.useCustomExplosions = this.customConfig.getBoolean("useCustomExplosions");
        }
        try {
            InputStreamReader defConfigStream = new InputStreamReader(this.getResource("config.yml"), "UTF8");
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                this.customConfig.setDefaults((Configuration)defConfig);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getCustomConfig() {
        if (this.customConfig == null) {
            this.reloadCustomConfig();
        }
        return this.customConfig;
    }

    public void saveCustomConfig() {
        if (this.customConfig == null || this.customConfigFile == null) {
            return;
        }
        try {
            this.getCustomConfig().save(this.customConfigFile);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save config to " + this.customConfigFile, ex);
        }
    }

    public void saveDefaultConfig() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.getDataFolder(), "config.yml");
        }
        if (!this.customConfigFile.exists()) {
            this.saveResource("config.yml", false);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
    }

    @EventHandler
    public void onPlayerDestroyBlock(BlockBreakEvent event) {
        Block block = event.getBlock();
        this.getDamageBlock(block.getLocation()).removeAllDamage();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (this.useCustomExplosions && !event.isCancelled() && event.blockList().size() > 0) {
            final ArrayList blocks = new ArrayList(event.blockList());
            event.blockList().clear();
            event.setYield(0.0f);
            final EntityExplodeEvent e = event;
            final Location explosion = event.getLocation();
            HashMap<Location, Material> materials = new HashMap<Location, Material>();
            for (Block block : blocks) {
                materials.put(block.getLocation(), block.getType());
            }
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    Random r = new Random();
                    for (Block block : blocks) {
                        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
                        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
                        if (block.getType() == Material.TNT) {
                            Entity entity = ((CraftEntity)e.getEntity()).getHandle();
                            EntityLiving shit = entity == null ? null : (entity instanceof EntityTNTPrimed ? ((EntityTNTPrimed)entity).getSource() : (entity instanceof EntityLiving ? (EntityLiving)entity : null));
                            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed((World)world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), shit);
                            entitytntprimed.fireTicks = world.random.nextInt(Math.max(entitytntprimed.fireTicks / 4, 1)) + entitytntprimed.fireTicks / 8;
                            world.addEntity((Entity)entitytntprimed);
                        }
                        double distance = explosion.distance(block.getLocation());
                        DamageBlock damageBlock = BetterBlockBreaking.this.getDamageBlock(block.getLocation());
                        damageBlock.setDamage((float)((double)(14 + (r.nextInt(5) - 2)) - 2.0 * distance + (double)damageBlock.getDamage()), null);
                    }
                }
            };
            runnable.runTaskLater((Plugin)this, 0L);
        }
    }

    public DamageBlock getDamageBlock(Location location) {
        DamageBlock damageBlock = this.damageBlocks.get(location);
        if (damageBlock == null) {
            damageBlock = new DamageBlock(location);
            this.damageBlocks.put(location, damageBlock);
        }
        return damageBlock;
    }

    public static BetterBlockBreaking getPlugin() {
        return (BetterBlockBreaking)Bukkit.getPluginManager().getPlugin("BetterBlockBreaking");
    }

    private Plugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            this.getServer().getLogger().log(Level.INFO, "[BetterBlockBreaking] WorldGuard could not be loaded. Disabling interaction.");
            return null;
        }
        this.getServer().getLogger().log(Level.INFO, "[BetterBlockBreaking] Enabled WorldGuard interaction.");
        return plugin;
    }
}

