/*
 * Decompiled with CFR 0.152.
 */
package net.bazingablocks.org.backend;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.bazingablocks.org.Main;
import net.bazingablocks.org.backend.Messages;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LuckyBlockFile {
    private static Plugin plugin = Main.getPlugin(Main.class);

    public static FileConfiguration get() {
        File file = new File(plugin.getDataFolder(), "luckyblocks.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        if (!file.exists()) {
            try {
                file.mkdir();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return yml;
    }

    public static void save() {
        File file = new File(plugin.getDataFolder(), "luckyblocks.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        if (file.exists()) {
            try {
                yml.save(file);
                System.out.println("[BazingaBlocks] Successfully saved file 'luckyblocks.yml'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                File dir = file.getParentFile();
                dir.mkdirs();
                file.createNewFile();
                yml.set("luckyblocks.1.material", (Object)"DIAMOND_BLOCK");
                yml.set("luckyblocks.1.requiredTools", Arrays.asList("DIAMOND_PICKAXE", "NETHERITE_PICKAXE"));
                yml.set("luckyblocks.1.effects.title", (Object)"&e&ki &6&lLUCKY &e&lBLOCK &6&ki");
                yml.set("luckyblocks.1.effects.subtitle", (Object)"&7You won broke a Lucky Block&7");
                yml.set("luckyblocks.1.effects.actionbar", (Object)"&7You won broke a Lucky Block&7");
                yml.set("luckyblocks.1.effects.particle", (Object)"SOUL_FIRE_FLAME");
                yml.set("luckyblocks.1.effects.sound", (Object)"BLOCK_BEACON_ACTIVATE");
                yml.set("luckyblocks.1.effects.lightning", (Object)true);
                yml.set("luckyblocks.1.effects.message", Arrays.asList(" ", " &6&lLUCKY &e&lBLOCK &8\u00bb &7Congratulations, you found a Lucky Block!", " "));
                yml.set("luckyblocks.1.rewards.1.probability", (Object)0.5);
                yml.set("luckyblocks.1.rewards.1.rewardName", (Object)"16x Diamonds");
                yml.set("luckyblocks.1.rewards.1.commands", Arrays.asList("give PLAYER diamond 16"));
                yml.set("luckyblocks.1.hologram.isEnabled", (Object)false);
                yml.set("luckyblocks.1.hologram.text", (Object)"&7You won broke a Lucky Block&7!");
                yml.set("luckyblocks.1.hologram.duration", (Object)3);
                yml.set("luckyblocks.1.hologram.heightOffset", (Object)1);
                yml.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void updateConfig() {
        File file = new File(plugin.getDataFolder(), "luckyblocks.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        if (yml.getConfigurationSection("luckyblocks.holograms") == null) {
            for (String lb : yml.getConfigurationSection("luckyblocks").getKeys(false)) {
                yml.set("luckyblocks." + lb + ".hologram.isEnabled", (Object)false);
                yml.set("luckyblocks." + lb + ".hologram.text", (Object)"&7You won broke a Lucky Block&7");
                yml.set("luckyblocks." + lb + ".hologram.duration", (Object)3);
                yml.set("luckyblocks." + lb + ".hologram.heightOffset", (Object)1);
            }
        }
        if (yml.getString("luckyblocks.1.holograms.isEnabled") == null) {
            for (String lb : yml.getConfigurationSection("luckyblocks").getKeys(false)) {
                yml.set("luckyblocks." + lb + ".hologram.isEnabled", (Object)false);
            }
        }
        try {
            yml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        LuckyBlockFile.save();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("bazingablock.admin")) continue;
            player.sendMessage(Messages.format("&6&lBazinga&e&lBlocks &8\u00bb &7Reloaded the plugin and checked for updates."));
        }
    }
}

