/*
 * Decompiled with CFR 0.152.
 */
package me.Cookle.AutoSellerChest;

import com.earth2me.essentials.Worth;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.Cookle.AutoSellerChest.ChestListener;
import me.Cookle.AutoSellerChest.CommandAutoSellerChest;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Directional;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Core
extends JavaPlugin {
    private final Plugin plugin = this;
    private ChestListener listener = new ChestListener(this);
    private static Worth worth = null;
    static Economy econ = null;
    static FileConfiguration config = null;

    public void onEnable() {
        this.saveDefaultConfig();
        config = this.loadConfig("config");
        Objects.requireNonNull(this.getCommand("ASC")).setExecutor((CommandExecutor)new CommandAutoSellerChest(this));
        Objects.requireNonNull(this.getCommand("AutoSellerChest")).setExecutor((CommandExecutor)new CommandAutoSellerChest(this));
        if (!this.setupEconomy()) {
            this.getLogger().info("No Vault dependence found! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin(this.plugin);
            return;
        }
        if (!this.setupWorth()) {
            this.getLogger().info("No worth dependence found! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin(this.plugin);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        new BukkitRunnable(){

            public void run() {
                Core.this.convertLegacyConfig();
            }
        }.runTaskLater(this.plugin, 160L);
    }

    public void onDisable() {
        worth = null;
        config = null;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return true;
    }

    private boolean setupWorth() {
        boolean price_manager = false;
        if (Objects.requireNonNull(config.getString("worth-plugin")).equalsIgnoreCase("Essentials") && this.getServer().getPluginManager().getPlugin("Essentials") != null) {
            File file = new File(this.plugin.getDataFolder().getParentFile(), "Essentials");
            if (!new File(file, "worth.yml").exists()) {
                return false;
            }
            worth = new Worth(file);
            price_manager = true;
        }
        if (Objects.requireNonNull(config.getString("worth-plugin")).equalsIgnoreCase("ShopGuiPlus") && this.getServer().getPluginManager().getPlugin("ShopGUIPlus") != null) {
            price_manager = true;
        }
        return price_manager;
    }

    private FileConfiguration loadConfig(String name) {
        File file = new File(this.plugin.getDataFolder(), name + ".yml");
        if (file.exists()) {
            return YamlConfiguration.loadConfiguration((File)file);
        }
        return null;
    }

    private void convertLegacyConfig() {
        FileConfiguration all_sellers = this.loadConfig("SellerChestData");
        if (all_sellers == null) {
            return;
        }
        HashMap<UUID, List> sellers = new HashMap<UUID, List>();
        this.getLogger().info("Converting Legacy Chest Data!");
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            List seller = all_sellers.getStringList(p.getUniqueId().toString());
            if (seller.size() <= 0) continue;
            sellers.put(p.getUniqueId(), seller);
        }
        for (UUID uuid : sellers.keySet()) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
            if (sellers.get(p.getUniqueId()) == null || ((List)sellers.get(p.getUniqueId())).size() <= 1) continue;
            List seller = (List)sellers.get(uuid);
            for (String i : seller) {
                Block s;
                List<String> elements = Arrays.asList(i.split(":"));
                World w = this.getServer().getWorld(elements.get(0));
                String[] sloc = elements.get(1).split(",");
                double amountMade = 0.0;
                if (elements.size() > 3) {
                    amountMade = Double.parseDouble(elements.get(3));
                }
                if (w == null || (s = w.getBlockAt(Integer.parseInt(sloc[0]), Integer.parseInt(sloc[1]), Integer.parseInt(sloc[2]))).getType() != Material.LEGACY_WALL_SIGN || Core.getChest(s) == null) continue;
                Sign sign = (Sign)s.getState();
                sign.setLine(0, ChatColor.GOLD + "" + ChatColor.BOLD + "-=(AutoSelling)=-");
                sign.setLine(1, Objects.requireNonNull(p.getName()));
                sign.setLine(2, "");
                String hide = "," + p.getUniqueId().toString() + "," + amountMade;
                StringBuilder hidden = new StringBuilder();
                for (char c : hide.toCharArray()) {
                    hidden.append("\u00a7").append(c).append(" ");
                }
                Block c = Core.getChest(s);
                if (c == null) continue;
                Chest chest = (Chest)c.getState();
                chest.setCustomName("Chest" + hidden.toString());
                sign.update();
                chest.update();
            }
        }
        File file = new File(this.plugin.getDataFolder(), "SellerChestData.yml");
        if (!file.delete()) {
            this.getLogger().info("Wasn't able to delete legacy config file... If you want this message to go away delete SellerChestData.yml!");
        }
    }

    private static String EconFormat(Double d) {
        String sum = "";
        DecimalFormat df = new DecimalFormat("###,###.###");
        if (d < Math.pow(10.0, 3.0)) {
            sum = sum + df.format(d);
        } else if (d < Math.pow(10.0, 6.0)) {
            d = d / Math.pow(10.0, 3.0);
            sum = sum + df.format(d) + "k";
        } else if (d < Math.pow(10.0, 9.0)) {
            d = d / Math.pow(10.0, 6.0);
            sum = sum + df.format(d) + "m";
        } else if (d < Math.pow(10.0, 12.0)) {
            d = d / Math.pow(10.0, 9.0);
            sum = sum + df.format(d) + "b";
        } else if (d < Math.pow(10.0, 15.0)) {
            d = d / Math.pow(10.0, 12.0);
            sum = sum + df.format(d) + "t";
        } else {
            df = new DecimalFormat("0.######E0");
            sum = sum + df.format(d);
        }
        return sum.replace("&", "\u00a7");
    }

    double getPrice(Player player, ItemStack itemStack) {
        String worth_plugin = Objects.requireNonNull(config.getString("worth-plugin"));
        if (worth != null) {
            BigDecimal bd = worth.getPrice(null, itemStack);
            if (bd == null) {
                return -1.0;
            }
            return bd.doubleValue();
        }
        if (worth_plugin.equalsIgnoreCase("ShopGuiPlus")) {
            try {
                if (ShopGuiPlugin.getInstance().getPlayerManager().getPlayerData((OfflinePlayer)player) == null) {
                    ShopGuiPlugin.getInstance().getPlayerManager().registerPlayer(player);
                }
                return ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)itemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1.0;
    }

    static String getFormatted(String unformatted_string, Player player, double amount_made) {
        String[] commands = new String[]{"%PLAYER-NAME%", "%AMOUNT_MADE_ECON_FORMATTED%"};
        unformatted_string = unformatted_string.replaceAll(commands[1], Core.EconFormat(amount_made));
        if (player != null) {
            unformatted_string = unformatted_string.replaceAll(commands[0], player.getDisplayName());
        }
        unformatted_string = unformatted_string.replaceAll("& ", "%#%").replaceAll("&", "\u00a7");
        return unformatted_string.replaceAll("%#%", "& ");
    }

    static BlockFace getFacing(Location loc) {
        double r = loc.getYaw() - 90.0f;
        if (r < 0.0) {
            r += 360.0;
        }
        if (r <= 0.0 && r < 45.0) {
            return BlockFace.NORTH;
        }
        if (r <= 45.0 && r < 135.0) {
            return BlockFace.EAST;
        }
        if (r <= 135.0 && r < 225.0) {
            return BlockFace.SOUTH;
        }
        if (r <= 225.0 && r < 315.0) {
            return BlockFace.WEST;
        }
        if (r < 360.0) {
            return BlockFace.NORTH;
        }
        return BlockFace.SELF;
    }

    static Block getChest(Block b) {
        WallSign signData = (WallSign)b.getState().getBlockData();
        BlockFace attached = signData.getFacing().getOppositeFace();
        return b.getRelative(attached);
    }

    static Block getSign(Block b) {
        Directional chestData = (Directional)b.getState().getData();
        BlockFace facing = chestData.getFacing();
        return b.getRelative(facing);
    }
}

