/*
 * Decompiled with CFR 0.152.
 */
package me.Cookle.AutoSellerChest;

import java.util.Objects;
import java.util.UUID;
import me.Cookle.AutoSellerChest.Core;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestListener
implements Listener {
    private Core plugin;

    ChestListener(Core plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void blockPlace(final BlockPlaceEvent e) {
        BlockFace[] bf;
        if (e.getBlock().getType() != Material.CHEST) {
            return;
        }
        for (BlockFace face : bf = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Sign s;
            Block sign;
            Block chest = e.getBlock().getRelative(face);
            if (chest.getType() != Material.CHEST || !(sign = Core.getSign(chest)).getState().getType().name().endsWith("WALL_SIGN") || !(s = (Sign)sign.getState()).getLine(0).equalsIgnoreCase(Core.getFormatted(Core.config.getString("sign-line-1"), null, -1.0))) continue;
            final Block b = e.getBlock();
            e.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    b.setType(Material.CHEST);
                    Chest c = (Chest)b.getState();
                    Directional chestData = (Directional)b.getState().getData();
                    chestData.setFacingDirection(Core.getFacing(e.getPlayer().getLocation()));
                    c.setData((MaterialData)chestData);
                    c.update();
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    @EventHandler
    public void breakBlock(BlockBreakEvent e) {
        if (e.getBlock().getState().getType().name().endsWith("WALL_SIGN")) {
            Sign s = (Sign)e.getBlock().getState();
            if (!s.getLine(0).equalsIgnoreCase(Core.getFormatted(Core.config.getString("sign-line-1"), null, -1.0))) {
                return;
            }
            Core.getChest(e.getBlock()).breakNaturally();
            e.getBlock().breakNaturally();
        }
    }

    @EventHandler
    public void transfer(InventoryMoveItemEvent e) {
        if (!e.getDestination().getType().equals((Object)InventoryType.CHEST)) {
            return;
        }
        Block chest = Objects.requireNonNull(e.getDestination().getLocation()).getBlock();
        Block sign = Core.getSign(chest);
        Sign s = (Sign)sign.getState();
        if (!s.getLine(0).equalsIgnoreCase(Core.getFormatted(Core.config.getString("sign-line-1"), null, -1.0))) {
            return;
        }
        Chest c = (Chest)chest.getState();
        String[] con = this.show(Objects.requireNonNull(c.getCustomName())).split(",");
        Player p = Bukkit.getOfflinePlayer((UUID)UUID.fromString(con[1])).getPlayer();
        double sell_price = this.plugin.getPrice(p, e.getItem());
        if (sell_price == -1.0) {
            return;
        }
        if (Core.econ.hasAccount((OfflinePlayer)p)) {
            Core.econ.depositPlayer((OfflinePlayer)p, sell_price * Core.config.getDouble("multiply-value"));
            double amount = Double.parseDouble(con[2]) + sell_price;
            c.setCustomName(con[0] + this.hide("," + con[1] + "," + amount));
            s.setLine(0, Core.getFormatted(Core.config.getString("sign-line-1"), p, -1.0));
            s.setLine(1, Core.getFormatted(Core.config.getString("sign-line-2"), p, amount));
            s.setLine(2, Core.getFormatted(Core.config.getString("sign-line-3"), p, amount));
            s.setLine(3, Core.getFormatted(Core.config.getString("sign-line-4"), p, amount));
            ItemStack is = e.getItem();
            is.setAmount(0);
            e.setItem(is);
            c.update();
            s.update();
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        boolean title = false;
        for (String c : Core.config.getStringList("seller-commands")) {
            if (!e.getLines()[0].equalsIgnoreCase(c)) continue;
            title = true;
        }
        if (!title) {
            return;
        }
        if (!e.getBlock().getState().getType().name().endsWith("WALL_SIGN")) {
            return;
        }
        Player p = e.getPlayer();
        if (!p.hasPermission("ASC.seller.create")) {
            p.sendMessage(ChatColor.RED + "You don't have permission to do that!");
            e.getBlock().breakNaturally();
            return;
        }
        Block chest = Core.getChest(e.getBlock());
        if (chest.getType() != Material.CHEST) {
            return;
        }
        Block sign = Core.getSign(chest);
        if (!sign.getType().name().endsWith("WALL_SIGN") || sign.getLocation().distance(e.getBlock().getLocation()) != 0.0) {
            p.sendMessage(ChatColor.RED + "You have to place sign on the front of the chest!");
            e.getBlock().breakNaturally();
            return;
        }
        Chest c = (Chest)chest.getState();
        if (c.getInventory() instanceof DoubleChestInventory) {
            p.sendMessage(ChatColor.RED + "You can't use double chests!");
            e.getBlock().breakNaturally();
            return;
        }
        e.setLine(0, Core.getFormatted(Core.config.getString("sign-line-1"), null, -1.0));
        e.setLine(1, Core.getFormatted(Core.config.getString("sign-line-2"), e.getPlayer(), 0.0));
        e.setLine(2, Core.getFormatted(Core.config.getString("sign-line-3"), e.getPlayer(), 0.0));
        e.setLine(3, Core.getFormatted(Core.config.getString("sign-line-4"), e.getPlayer(), 0.0));
        c.setCustomName("Chest" + this.hide("," + p.getUniqueId().toString() + ",0"));
        c.update();
    }

    private String hide(String text) {
        StringBuilder hidden = new StringBuilder();
        for (char c : text.toCharArray()) {
            hidden.append("\u00a7").append(c).append(" ");
        }
        return hidden.toString();
    }

    private String show(String text) {
        return text.replace("\u00a7", "").replace(" ", "");
    }
}

