/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.ProtectionSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.CollectionUtils;
import fr.xephi.authme.util.GeoLiteAPI;
import fr.xephi.authme.util.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.bukkit.command.CommandSender;

public class ValidationService
implements Reloadable {
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private GeoLiteAPI geoLiteApi;
    private Pattern passwordRegex;
    private Set<String> unrestrictedNames;

    ValidationService() {
    }

    @Override
    @PostConstruct
    public void reload() {
        this.passwordRegex = Utils.safePatternCompile(this.settings.getProperty(RestrictionSettings.ALLOWED_PASSWORD_REGEX));
        this.unrestrictedNames = new HashSet<String>((Collection)this.settings.getProperty(RestrictionSettings.UNRESTRICTED_NAMES));
    }

    public ValidationResult validatePassword(String password, String username) {
        String passLow = password.toLowerCase();
        if (!this.passwordRegex.matcher(passLow).matches()) {
            return new ValidationResult(MessageKey.PASSWORD_CHARACTERS_ERROR, this.passwordRegex.pattern());
        }
        if (passLow.equalsIgnoreCase(username)) {
            return new ValidationResult(MessageKey.PASSWORD_IS_USERNAME_ERROR, new String[0]);
        }
        if (password.length() < this.settings.getProperty(SecuritySettings.MIN_PASSWORD_LENGTH) || password.length() > this.settings.getProperty(SecuritySettings.MAX_PASSWORD_LENGTH)) {
            return new ValidationResult(MessageKey.INVALID_PASSWORD_LENGTH, new String[0]);
        }
        if (this.settings.getProperty(SecuritySettings.UNSAFE_PASSWORDS).contains(passLow)) {
            return new ValidationResult(MessageKey.PASSWORD_UNSAFE_ERROR, new String[0]);
        }
        return new ValidationResult();
    }

    public boolean validateEmail(String email) {
        if (!email.contains("@") || "your@email.com".equalsIgnoreCase(email)) {
            return false;
        }
        String emailDomain = email.split("@")[1];
        return this.validateWhitelistAndBlacklist(emailDomain, EmailSettings.DOMAIN_WHITELIST, EmailSettings.DOMAIN_BLACKLIST);
    }

    public boolean isEmailFreeForRegistration(String email, CommandSender sender) {
        return this.permissionsManager.hasPermission(sender, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) || this.dataSource.countAuthsByEmail(email) < this.settings.getProperty(EmailSettings.MAX_REG_PER_EMAIL);
    }

    public boolean isCountryAdmitted(String hostAddress) {
        if (this.settings.getProperty(ProtectionSettings.COUNTRIES_WHITELIST).isEmpty() && this.settings.getProperty(ProtectionSettings.COUNTRIES_BLACKLIST).isEmpty()) {
            return true;
        }
        String countryCode = this.geoLiteApi.getCountryCode(hostAddress);
        return this.validateWhitelistAndBlacklist(countryCode, ProtectionSettings.COUNTRIES_WHITELIST, ProtectionSettings.COUNTRIES_BLACKLIST);
    }

    public boolean isUnrestricted(String name) {
        return this.unrestrictedNames.contains(name.toLowerCase());
    }

    private boolean validateWhitelistAndBlacklist(String value, Property<List<String>> whitelist, Property<List<String>> blacklist) {
        List<String> whitelistValue = this.settings.getProperty(whitelist);
        if (!CollectionUtils.isEmpty(whitelistValue)) {
            return ValidationService.containsIgnoreCase(whitelistValue, value);
        }
        List<String> blacklistValue = this.settings.getProperty(blacklist);
        return CollectionUtils.isEmpty(blacklistValue) || !ValidationService.containsIgnoreCase(blacklistValue, value);
    }

    private static boolean containsIgnoreCase(Collection<String> coll, String needle) {
        for (String entry : coll) {
            if (!entry.equalsIgnoreCase(needle)) continue;
            return true;
        }
        return false;
    }

    public static final class ValidationResult {
        private final MessageKey messageKey;
        private final String[] args;

        public ValidationResult() {
            this.messageKey = null;
            this.args = null;
        }

        public ValidationResult(MessageKey messageKey, String ... args) {
            this.messageKey = messageKey;
            this.args = args;
        }

        public boolean hasError() {
            return this.messageKey != null;
        }

        public MessageKey getMessageKey() {
            return this.messageKey;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

