/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.ConsoleLogger;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class Utils {
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;

    private Utils() {
    }

    public static String getUUIDorName(OfflinePlayer player) {
        try {
            return player.getUniqueId().toString();
        }
        catch (NoSuchMethodError ignore) {
            return player.getName();
        }
    }

    public static Pattern safePatternCompile(String pattern) {
        try {
            return Pattern.compile(pattern);
        }
        catch (Exception e) {
            ConsoleLogger.warning("Failed to compile pattern '" + pattern + "' - defaulting to allowing everything");
            return Pattern.compile(".*?");
        }
    }

    public static String getPlayerIp(Player p) {
        return p.getAddress().getAddress().getHostAddress();
    }

    public static boolean isClassLoaded(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

