/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.AbstractTeleportEvent;
import fr.xephi.authme.events.AuthMeTeleportEvent;
import fr.xephi.authme.events.FirstSpawnTeleportEvent;
import fr.xephi.authme.events.SpawnTeleportEvent;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.BukkitService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TeleportationService
implements Reloadable {
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private DataSource dataSource;
    private Set<String> spawnOnLoginWorlds;

    TeleportationService() {
    }

    @Override
    @PostConstruct
    public void reload() {
        this.spawnOnLoginWorlds = new HashSet<String>((Collection)this.settings.getProperty(RestrictionSettings.FORCE_SPAWN_ON_WORLDS));
    }

    public void teleportOnJoin(Player player) {
        if (!this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue() && this.settings.getProperty(RestrictionSettings.TELEPORT_UNAUTHED_TO_SPAWN).booleanValue()) {
            this.teleportToSpawn(player, this.playerCache.isAuthenticated(player.getName()));
        }
    }

    public void teleportNewPlayerToFirstSpawn(Player player) {
        if (this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue()) {
            return;
        }
        Location firstSpawn = this.spawnLoader.getFirstSpawn();
        if (firstSpawn == null) {
            return;
        }
        if (!player.hasPlayedBefore() || !this.dataSource.isAuthAvailable(player.getName())) {
            this.performTeleportation(player, new FirstSpawnTeleportEvent(player, firstSpawn));
        }
    }

    public void teleportOnLogin(Player player, PlayerAuth auth, PlayerData limbo) {
        String worldName;
        if (this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue()) {
            return;
        }
        String string = worldName = limbo != null && limbo.getLocation() != null ? limbo.getLocation().getWorld().getName() : null;
        if (this.mustForceSpawnAfterLogin(worldName)) {
            this.teleportToSpawn(player, true);
        } else if (this.settings.getProperty(RestrictionSettings.TELEPORT_UNAUTHED_TO_SPAWN).booleanValue()) {
            if (this.settings.getProperty(RestrictionSettings.SAVE_QUIT_LOCATION).booleanValue() && auth.getQuitLocY() != 0.0) {
                Location location = this.buildLocationFromAuth(player, auth);
                this.teleportBackFromSpawn(player, location);
            } else if (limbo != null && limbo.getLocation() != null) {
                this.teleportBackFromSpawn(player, limbo.getLocation());
            }
        }
    }

    private boolean mustForceSpawnAfterLogin(String worldName) {
        return worldName != null && this.settings.getProperty(RestrictionSettings.FORCE_SPAWN_LOCATION_AFTER_LOGIN) != false && this.spawnOnLoginWorlds.contains(worldName);
    }

    private Location buildLocationFromAuth(Player player, PlayerAuth auth) {
        World world = this.bukkitService.getWorld(auth.getWorld());
        if (world == null) {
            world = player.getWorld();
        }
        return new Location(world, auth.getQuitLocX(), auth.getQuitLocY(), auth.getQuitLocZ());
    }

    private void teleportBackFromSpawn(Player player, Location location) {
        this.performTeleportation(player, new AuthMeTeleportEvent(player, location));
    }

    private void teleportToSpawn(Player player, boolean isAuthenticated) {
        Location spawnLoc = this.spawnLoader.getSpawnLocation(player);
        this.performTeleportation(player, new SpawnTeleportEvent(player, spawnLoc, isAuthenticated));
    }

    private void performTeleportation(final Player player, final AbstractTeleportEvent event) {
        this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                TeleportationService.this.bukkitService.callEvent(event);
                if (player.isOnline() && TeleportationService.isEventValid(event)) {
                    player.teleport(event.getTo());
                }
            }
        });
    }

    private static boolean isEventValid(AbstractTeleportEvent event) {
        return !event.isCancelled() && event.getTo() != null && event.getTo().getWorld() != null;
    }
}

